/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.MinecraftServer;
import net.minestom.server.coordinate.BlockVec;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.instance.InstanceChunkLoadEvent;
import net.minestom.server.event.instance.InstanceChunkUnloadEvent;
import net.minestom.server.event.player.PlayerBlockBreakEvent;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.DynamicChunk;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.IChunkLoader;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.SharedInstance;
import net.minestom.server.instance.anvil.AnvilLoader;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.block.rule.BlockPlacementRule;
import net.minestom.server.instance.generator.GenerationUnit;
import net.minestom.server.instance.generator.Generator;
import net.minestom.server.instance.generator.GeneratorImpl;
import net.minestom.server.instance.generator.UnitModifier;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.network.packet.server.play.BlockChangePacket;
import net.minestom.server.network.packet.server.play.BlockEntityDataPacket;
import net.minestom.server.network.packet.server.play.EffectPacket;
import net.minestom.server.network.packet.server.play.UnloadChunkPacket;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registry;
import net.minestom.server.thread.ThreadDispatcher;
import net.minestom.server.utils.Direction;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.PacketSendingUtils;
import net.minestom.server.utils.async.AsyncUtils;
import net.minestom.server.utils.block.BlockUtils;
import net.minestom.server.utils.chunk.ChunkCache;
import net.minestom.server.utils.chunk.ChunkSupplier;
import net.minestom.server.utils.chunk.ChunkUtils;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.DimensionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import space.vectrix.flare.fastutil.Long2ObjectSyncMap;

public class InstanceContainer
extends Instance {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceContainer.class);
    private static final AnvilLoader DEFAULT_LOADER = new AnvilLoader("world");
    private static final BlockFace[] BLOCK_UPDATE_FACES = new BlockFace[]{BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.BOTTOM, BlockFace.TOP};
    private final List<SharedInstance> sharedInstances = new CopyOnWriteArrayList<SharedInstance>();
    private volatile Generator generator;
    private final Long2ObjectSyncMap<Chunk> chunks = Long2ObjectSyncMap.hashmap();
    private final Map<Long, CompletableFuture<Chunk>> loadingChunks = new ConcurrentHashMap<Long, CompletableFuture<Chunk>>();
    private final Lock changingBlockLock = new ReentrantLock();
    private final Map<Point, Block> currentlyChangingBlocks = new HashMap<Point, Block>();
    private IChunkLoader chunkLoader;
    private boolean autoChunkLoad = true;
    private ChunkSupplier chunkSupplier;
    protected InstanceContainer srcInstance;
    private long lastBlockChangeTime;
    Map<Long, List<GeneratorImpl.SectionModifierImpl>> generationForks = new ConcurrentHashMap<Long, List<GeneratorImpl.SectionModifierImpl>>();

    public InstanceContainer(@NotNull UUID uniqueId, @NotNull DynamicRegistry.Key<DimensionType> dimensionType) {
        this(uniqueId, dimensionType, null, dimensionType.namespace());
    }

    public InstanceContainer(@NotNull UUID uniqueId, @NotNull DynamicRegistry.Key<DimensionType> dimensionType, @NotNull NamespaceID dimensionName) {
        this(uniqueId, dimensionType, null, dimensionName);
    }

    public InstanceContainer(@NotNull UUID uniqueId, @NotNull DynamicRegistry.Key<DimensionType> dimensionType, @Nullable IChunkLoader loader) {
        this(uniqueId, dimensionType, loader, dimensionType.namespace());
    }

    public InstanceContainer(@NotNull UUID uniqueId, @NotNull DynamicRegistry.Key<DimensionType> dimensionType, @Nullable IChunkLoader loader, @NotNull NamespaceID dimensionName) {
        this(MinecraftServer.getDimensionTypeRegistry(), uniqueId, dimensionType, loader, dimensionName);
    }

    public InstanceContainer(@NotNull DynamicRegistry<DimensionType> dimensionTypeRegistry, @NotNull UUID uniqueId, @NotNull DynamicRegistry.Key<DimensionType> dimensionType, @Nullable IChunkLoader loader, @NotNull NamespaceID dimensionName) {
        super(dimensionTypeRegistry, uniqueId, dimensionType, dimensionName);
        this.setChunkSupplier(DynamicChunk::new);
        this.setChunkLoader(Objects.requireNonNullElse(loader, DEFAULT_LOADER));
        this.chunkLoader.loadInstance(this);
    }

    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block, boolean doBlockUpdates) {
        Chunk chunk = this.getChunkAt(x, z);
        if (chunk == null) {
            Check.stateCondition(!this.hasEnabledAutoChunkLoad(), "Tried to set a block to an unloaded chunk with auto chunk load disabled");
            chunk = this.loadChunk(CoordConversion.globalToChunk(x), CoordConversion.globalToChunk(z)).join();
        }
        if (ChunkUtils.isLoaded(chunk)) {
            this.UNSAFE_setBlock(chunk, x, y, z, block, null, null, doBlockUpdates, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void UNSAFE_setBlock(@NotNull Chunk chunk, int x, int y, int z, @NotNull Block block, @Nullable BlockHandler.Placement placement, @Nullable BlockHandler.Destroy destroy, boolean doBlockUpdates, int updateDistance) {
        if (chunk.isReadOnly()) {
            return;
        }
        DimensionType dim = this.getCachedDimensionType();
        if (y >= dim.maxY() || y < dim.minY()) {
            LOGGER.warn("tried to set a block outside the world bounds, should be within [{}, {}): {}", new Object[]{dim.minY(), dim.maxY(), y});
            return;
        }
        Chunk chunk2 = chunk;
        synchronized (chunk2) {
            this.lastBlockChangeTime = System.currentTimeMillis();
            Vec blockPosition = new Vec(x, y, z);
            if (this.isAlreadyChanged(blockPosition, block)) {
                return;
            }
            this.currentlyChangingBlocks.put(blockPosition, block);
            BlockPlacementRule blockPlacementRule = MinecraftServer.getBlockManager().getBlockPlacementRule(block);
            if (placement != null && blockPlacementRule != null && doBlockUpdates) {
                BlockPlacementRule.PlacementState rulePlacement;
                if (placement instanceof BlockHandler.PlayerPlacement) {
                    BlockHandler.PlayerPlacement pp = (BlockHandler.PlayerPlacement)placement;
                    rulePlacement = new BlockPlacementRule.PlacementState(this, block, pp.getBlockFace(), blockPosition, new Vec(pp.getCursorX(), pp.getCursorY(), pp.getCursorZ()), pp.getPlayer().getPosition(), pp.getPlayer().getItemInHand(pp.getHand()), pp.getPlayer().isSneaking());
                } else {
                    rulePlacement = new BlockPlacementRule.PlacementState(this, block, null, blockPosition, null, null, null, false);
                }
                block = blockPlacementRule.blockPlace(rulePlacement);
                if (block == null) {
                    block = Block.AIR;
                }
            }
            chunk.setBlock(x, y, z, block, placement, destroy);
            if (doBlockUpdates) {
                this.executeNeighboursBlockPlacementRule(blockPosition, updateDistance);
            }
            chunk.sendPacketToViewers(new BlockChangePacket((Point)blockPosition, block.stateId()));
            Registry.BlockEntry registry = block.registry();
            if (registry.isBlockEntity()) {
                CompoundBinaryTag data = BlockUtils.extractClientNbt(block);
                chunk.sendPacketToViewers(new BlockEntityDataPacket(blockPosition, registry.blockEntityId(), data));
            }
        }
    }

    @Override
    public boolean placeBlock(@NotNull BlockHandler.Placement placement, boolean doBlockUpdates) {
        Point blockPosition = placement.getBlockPosition();
        Chunk chunk = this.getChunkAt(blockPosition);
        if (!ChunkUtils.isLoaded(chunk)) {
            return false;
        }
        this.UNSAFE_setBlock(chunk, blockPosition.blockX(), blockPosition.blockY(), blockPosition.blockZ(), placement.getBlock(), placement, null, doBlockUpdates, 0);
        return true;
    }

    @Override
    public boolean breakBlock(@NotNull Player player, @NotNull Point blockPosition, @NotNull BlockFace blockFace, boolean doBlockUpdates) {
        boolean allowed;
        Chunk chunk = this.getChunkAt(blockPosition);
        Check.notNull(chunk, "You cannot break blocks in a null chunk!");
        if (chunk.isReadOnly()) {
            return false;
        }
        if (!ChunkUtils.isLoaded(chunk)) {
            return false;
        }
        Block block = this.getBlock(blockPosition);
        int x = blockPosition.blockX();
        int y = blockPosition.blockY();
        int z = blockPosition.blockZ();
        if (block.isAir()) {
            chunk.sendChunk(player);
            return false;
        }
        PlayerBlockBreakEvent blockBreakEvent = new PlayerBlockBreakEvent(player, block, Block.AIR, new BlockVec(blockPosition), blockFace);
        EventDispatcher.call(blockBreakEvent);
        boolean bl = allowed = !blockBreakEvent.isCancelled();
        if (allowed) {
            Block resultBlock = blockBreakEvent.getResultBlock();
            this.UNSAFE_setBlock(chunk, x, y, z, resultBlock, null, new BlockHandler.PlayerDestroy(block, this, blockPosition, player), doBlockUpdates, 0);
            PacketSendingUtils.sendGroupedPacket(chunk.getViewers(), new EffectPacket(2001, blockPosition, block.stateId(), false), viewer -> !viewer.equals(player));
        }
        return allowed;
    }

    @Override
    @NotNull
    public CompletableFuture<Chunk> loadChunk(int chunkX, int chunkZ) {
        return this.loadOrRetrieve(chunkX, chunkZ, () -> this.retrieveChunk(chunkX, chunkZ));
    }

    @Override
    @NotNull
    public CompletableFuture<Chunk> loadOptionalChunk(int chunkX, int chunkZ) {
        return this.loadOrRetrieve(chunkX, chunkZ, () -> this.hasEnabledAutoChunkLoad() ? this.retrieveChunk(chunkX, chunkZ) : AsyncUtils.empty());
    }

    @Override
    public synchronized void unloadChunk(@NotNull Chunk chunk) {
        if (!ChunkUtils.isLoaded(chunk)) {
            return;
        }
        int chunkX = chunk.getChunkX();
        int chunkZ = chunk.getChunkZ();
        chunk.sendPacketToViewers(new UnloadChunkPacket(chunkX, chunkZ));
        EventDispatcher.call(new InstanceChunkUnloadEvent(this, chunk));
        this.getEntityTracker().chunkEntities(chunkX, chunkZ, EntityTracker.Target.ENTITIES).forEach(Entity::remove);
        this.chunks.remove(CoordConversion.chunkIndex(chunkX, chunkZ));
        chunk.unload();
        this.chunkLoader.unloadChunk(chunk);
        ThreadDispatcher<Chunk> dispatcher = MinecraftServer.process().dispatcher();
        dispatcher.deletePartition(chunk);
    }

    @Override
    public Chunk getChunk(int chunkX, int chunkZ) {
        return (Chunk)this.chunks.get(CoordConversion.chunkIndex(chunkX, chunkZ));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> saveInstance() {
        IChunkLoader chunkLoader = this.chunkLoader;
        return this.optionalAsync(chunkLoader.supportsParallelSaving(), () -> chunkLoader.saveInstance(this));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> saveChunkToStorage(@NotNull Chunk chunk) {
        IChunkLoader chunkLoader = this.chunkLoader;
        return this.optionalAsync(chunkLoader.supportsParallelSaving(), () -> chunkLoader.saveChunk(chunk));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> saveChunksToStorage() {
        IChunkLoader chunkLoader = this.chunkLoader;
        return this.optionalAsync(chunkLoader.supportsParallelSaving(), () -> chunkLoader.saveChunks(this.getChunks()));
    }

    private CompletableFuture<Void> optionalAsync(boolean async, Runnable runnable) {
        if (!async) {
            runnable.run();
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread.startVirtualThread(() -> {
            try {
                runnable.run();
                future.complete(null);
            }
            catch (Throwable e) {
                MinecraftServer.getExceptionManager().handleException(e);
            }
        });
        return future;
    }

    @NotNull
    protected @NotNull CompletableFuture<@NotNull Chunk> retrieveChunk(int chunkX, int chunkZ) {
        CompletableFuture<Chunk> completableFuture = new CompletableFuture<Chunk>();
        long index = CoordConversion.chunkIndex(chunkX, chunkZ);
        CompletableFuture<Chunk> prev = this.loadingChunks.putIfAbsent(index, completableFuture);
        if (prev != null) {
            return prev;
        }
        IChunkLoader loader = this.chunkLoader;
        Consumer<Chunk> generate = chunk -> {
            if (chunk == null) {
                chunk = this.createChunk(chunkX, chunkZ);
                chunk.onGenerate();
            }
            this.cacheChunk((Chunk)chunk);
            chunk.onLoad();
            EventDispatcher.call(new InstanceChunkLoadEvent(this, (Chunk)chunk));
            CompletableFuture<Chunk> future = this.loadingChunks.remove(index);
            assert (future == completableFuture) : "Invalid future: " + String.valueOf(future);
            completableFuture.complete((Chunk)chunk);
        };
        if (loader.supportsParallelLoading()) {
            Thread.startVirtualThread(() -> {
                try {
                    Chunk chunk = loader.loadChunk(this, chunkX, chunkZ);
                    generate.accept(chunk);
                }
                catch (Throwable e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
            });
        } else {
            Chunk chunk2 = loader.loadChunk(this, chunkX, chunkZ);
            Thread.startVirtualThread(() -> {
                try {
                    generate.accept(chunk2);
                }
                catch (Throwable e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
            });
        }
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Chunk createChunk(int chunkX, int chunkZ) {
        Chunk chunk = this.chunkSupplier.createChunk(this, chunkX, chunkZ);
        Check.notNull(chunk, "Chunks supplied by a ChunkSupplier cannot be null.");
        Generator generator = this.generator();
        if (generator == null || !chunk.shouldGenerate()) {
            this.processFork(chunk);
            return chunk;
        }
        GeneratorImpl.GenSection[] genSections = new GeneratorImpl.GenSection[chunk.getSections().size()];
        Arrays.setAll(genSections, i -> {
            Section section = chunk.getSections().get(i);
            return new GeneratorImpl.GenSection(section.blockPalette(), section.biomePalette());
        });
        GeneratorImpl.UnitImpl chunkUnit = GeneratorImpl.chunk(MinecraftServer.getBiomeRegistry(), genSections, chunk.getChunkX(), chunk.minSection, chunk.getChunkZ());
        try {
            generator.generate(chunkUnit);
            UnitModifier unitModifier = chunkUnit.modifier();
            if (unitModifier instanceof GeneratorImpl.AreaModifierImpl) {
                GeneratorImpl.AreaModifierImpl chunkModifier = (GeneratorImpl.AreaModifierImpl)unitModifier;
                for (GenerationUnit section : chunkModifier.sections()) {
                    UnitModifier unitModifier2 = section.modifier();
                    if (!(unitModifier2 instanceof GeneratorImpl.SectionModifierImpl)) continue;
                    GeneratorImpl.SectionModifierImpl sectionModifier = (GeneratorImpl.SectionModifierImpl)unitModifier2;
                    this.applyGenerationData(chunk, sectionModifier);
                }
            }
            for (GeneratorImpl.UnitImpl fork : chunkUnit.forks()) {
                List<GenerationUnit> sections = ((GeneratorImpl.AreaModifierImpl)fork.modifier()).sections();
                for (GenerationUnit section : sections) {
                    Chunk forkChunk;
                    GeneratorImpl.SectionModifierImpl sectionModifier;
                    UnitModifier unitModifier3 = section.modifier();
                    if (!(unitModifier3 instanceof GeneratorImpl.SectionModifierImpl) || (sectionModifier = (GeneratorImpl.SectionModifierImpl)unitModifier3).genSection().blocks().count() == 0) continue;
                    Point start = section.absoluteStart();
                    Chunk chunk2 = forkChunk = start.chunkX() == chunkX && start.chunkZ() == chunkZ ? chunk : this.getChunkAt(start);
                    if (forkChunk != null) {
                        this.applyFork(forkChunk, sectionModifier);
                        forkChunk.invalidate();
                        forkChunk.sendChunk();
                        continue;
                    }
                    long index = CoordConversion.chunkIndex(start);
                    this.generationForks.compute(index, (i, sectionModifiers) -> {
                        if (sectionModifiers == null) {
                            sectionModifiers = new ArrayList<GeneratorImpl.SectionModifierImpl>();
                        }
                        sectionModifiers.add(sectionModifier);
                        return sectionModifiers;
                    });
                }
            }
            this.processFork(chunk);
        }
        catch (Throwable e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
        finally {
            this.refreshLastBlockChangeTime();
        }
        return chunk;
    }

    private void processFork(Chunk chunk) {
        this.generationForks.compute(CoordConversion.chunkIndex(chunk.getChunkX(), chunk.getChunkZ()), (aLong, sectionModifiers) -> {
            if (sectionModifiers != null) {
                for (GeneratorImpl.SectionModifierImpl sectionModifier : sectionModifiers) {
                    this.applyFork(chunk, sectionModifier);
                }
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFork(Chunk chunk, GeneratorImpl.SectionModifierImpl sectionModifier) {
        Chunk chunk2 = chunk;
        synchronized (chunk2) {
            Section section = chunk.getSectionAt(sectionModifier.start().blockY());
            Palette currentBlocks = section.blockPalette();
            sectionModifier.genSection().blocks().getAllPresent((x, y, z, value) -> currentBlocks.set(x, y, z, value - 1));
            this.applyGenerationData(chunk, sectionModifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyGenerationData(Chunk chunk, GeneratorImpl.SectionModifierImpl section) {
        Int2ObjectMap<Block> cache = section.genSection().specials();
        if (cache.isEmpty()) {
            return;
        }
        int height = section.start().blockY();
        Chunk chunk2 = chunk;
        synchronized (chunk2) {
            Int2ObjectMaps.fastForEach(cache, blockEntry -> {
                int index = blockEntry.getIntKey();
                Block block = (Block)blockEntry.getValue();
                int x = CoordConversion.chunkBlockIndexGetX(index);
                int y = CoordConversion.chunkBlockIndexGetY(index) + height;
                int z = CoordConversion.chunkBlockIndexGetZ(index);
                chunk.setBlock(x, y, z, block);
            });
        }
    }

    @Override
    public void enableAutoChunkLoad(boolean enable) {
        this.autoChunkLoad = enable;
    }

    @Override
    public boolean hasEnabledAutoChunkLoad() {
        return this.autoChunkLoad;
    }

    @Override
    public boolean isInVoid(@NotNull Point point) {
        return point.y() < (double)(this.getCachedDimensionType().minY() - 64);
    }

    @Override
    public void setChunkSupplier(@NotNull ChunkSupplier chunkSupplier) {
        this.chunkSupplier = chunkSupplier;
    }

    @Override
    public ChunkSupplier getChunkSupplier() {
        return this.chunkSupplier;
    }

    public List<SharedInstance> getSharedInstances() {
        return Collections.unmodifiableList(this.sharedInstances);
    }

    public boolean hasSharedInstances() {
        return !this.sharedInstances.isEmpty();
    }

    protected void addSharedInstance(SharedInstance sharedInstance) {
        this.sharedInstances.add(sharedInstance);
    }

    public synchronized InstanceContainer copy() {
        InstanceContainer copiedInstance = new InstanceContainer(UUID.randomUUID(), this.getDimensionType());
        copiedInstance.srcInstance = this;
        copiedInstance.tagHandler = this.tagHandler.copy();
        copiedInstance.lastBlockChangeTime = this.lastBlockChangeTime;
        for (Chunk chunk : this.chunks.values()) {
            int chunkX = chunk.getChunkX();
            int chunkZ = chunk.getChunkZ();
            Chunk copiedChunk = chunk.copy(copiedInstance, chunkX, chunkZ);
            copiedInstance.cacheChunk(copiedChunk);
        }
        return copiedInstance;
    }

    @Nullable
    public InstanceContainer getSrcInstance() {
        return this.srcInstance;
    }

    public long getLastBlockChangeTime() {
        return this.lastBlockChangeTime;
    }

    public void refreshLastBlockChangeTime() {
        this.lastBlockChangeTime = System.currentTimeMillis();
    }

    @Override
    @Nullable
    public Generator generator() {
        return this.generator;
    }

    @Override
    public void setGenerator(@Nullable Generator generator) {
        this.generator = generator;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Chunk> getChunks() {
        return this.chunks.values();
    }

    @NotNull
    public IChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }

    public void setChunkLoader(@NotNull IChunkLoader chunkLoader) {
        this.chunkLoader = Objects.requireNonNull(chunkLoader, "Chunk loader cannot be null");
    }

    @Override
    public void tick(long time) {
        super.tick(time);
        Lock wrlock = this.changingBlockLock;
        wrlock.lock();
        this.currentlyChangingBlocks.clear();
        wrlock.unlock();
    }

    private boolean isAlreadyChanged(@NotNull Point blockPosition, @NotNull Block block) {
        Block changedBlock = this.currentlyChangingBlocks.get(blockPosition);
        return Objects.equals(changedBlock, block);
    }

    private void executeNeighboursBlockPlacementRule(@NotNull Point blockPosition, int updateDistance) {
        ChunkCache cache = new ChunkCache(this, null, null);
        for (BlockFace updateFace : BLOCK_UPDATE_FACES) {
            Chunk chunk;
            Vec neighborPosition;
            Block newNeighborBlock;
            BlockPlacementRule neighborBlockPlacementRule;
            Block neighborBlock;
            Direction direction = updateFace.toDirection();
            int neighborX = blockPosition.blockX() + direction.normalX();
            int neighborY = blockPosition.blockY() + direction.normalY();
            int neighborZ = blockPosition.blockZ() + direction.normalZ();
            if (neighborY < this.getCachedDimensionType().minY() || neighborY > this.getCachedDimensionType().height() || (neighborBlock = cache.getBlock(neighborX, neighborY, neighborZ, Block.Getter.Condition.NONE)) == null || neighborBlock.isAir() || (neighborBlockPlacementRule = MinecraftServer.getBlockManager().getBlockPlacementRule(neighborBlock)) == null || updateDistance >= neighborBlockPlacementRule.maxUpdateDistance() || neighborBlock == (newNeighborBlock = neighborBlockPlacementRule.blockUpdate(new BlockPlacementRule.UpdateState(this, neighborPosition = new Vec(neighborX, neighborY, neighborZ), neighborBlock, updateFace.getOppositeFace()))) || !ChunkUtils.isLoaded(chunk = this.getChunkAt(neighborPosition))) continue;
            this.UNSAFE_setBlock(chunk, neighborPosition.blockX(), neighborPosition.blockY(), neighborPosition.blockZ(), newNeighborBlock, null, null, true, updateDistance + 1);
        }
    }

    private CompletableFuture<Chunk> loadOrRetrieve(int chunkX, int chunkZ, Supplier<CompletableFuture<Chunk>> supplier) {
        Chunk chunk = this.getChunk(chunkX, chunkZ);
        if (chunk != null) {
            return CompletableFuture.completedFuture(chunk);
        }
        return supplier.get();
    }

    private void cacheChunk(@NotNull Chunk chunk) {
        this.chunks.put(CoordConversion.chunkIndex(chunk.getChunkX(), chunk.getChunkZ()), (Object)chunk);
        ThreadDispatcher<Chunk> dispatcher = MinecraftServer.process().dispatcher();
        dispatcher.createPartition(chunk);
    }
}

