/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.monster;

import net.minestom.server.collision.BoundingBox;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.monster.BasePiglinMeta;
import org.jetbrains.annotations.NotNull;

public class PiglinMeta
extends BasePiglinMeta {
    public PiglinMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public boolean isBaby() {
        return this.metadata.get(MetadataDef.Piglin.IS_BABY);
    }

    public void setBaby(boolean value) {
        if (this.isBaby() == value) {
            return;
        }
        this.consumeEntity(entity -> {
            BoundingBox bb = entity.getBoundingBox();
            if (value) {
                double width = bb.width() / 2.0;
                entity.setBoundingBox(width, bb.height() / 2.0, width);
            } else {
                double width = bb.width() * 2.0;
                entity.setBoundingBox(width, bb.height() * 2.0, width);
            }
        });
        this.metadata.set(MetadataDef.Piglin.IS_BABY, value);
    }

    public boolean isChargingCrossbow() {
        return this.metadata.get(MetadataDef.Piglin.IS_CHARGING_CROSSBOW);
    }

    public void setChargingCrossbow(boolean value) {
        this.metadata.set(MetadataDef.Piglin.IS_CHARGING_CROSSBOW, value);
    }

    public boolean isDancing() {
        return this.metadata.get(MetadataDef.Piglin.IS_DANCING);
    }

    public void setDancing(boolean value) {
        this.metadata.set(MetadataDef.Piglin.IS_DANCING, value);
    }
}

