/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public enum RecipeType implements StaticProtocolObject
{
    CRAFTING(NamespaceID.from("minecraft:crafting")),
    SMELTING(NamespaceID.from("minecraft:smelting")),
    BLASTING(NamespaceID.from("minecraft:blasting")),
    SMOKING(NamespaceID.from("minecraft:smoking")),
    CAMPFIRE_COOKING(NamespaceID.from("minecraft:campfire_cooking")),
    STONECUTTING(NamespaceID.from("minecraft:stonecutting")),
    SMITHING(NamespaceID.from("minecraft:smithing"));

    public static final NetworkBuffer.Type<RecipeType> NETWORK_TYPE;
    public static final BinaryTagSerializer<RecipeType> NBT_TYPE;
    private final NamespaceID namespace;

    private RecipeType(NamespaceID namespace) {
        this.namespace = namespace;
    }

    @Override
    @NotNull
    public NamespaceID namespace() {
        return this.namespace;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        NETWORK_TYPE = NetworkBuffer.Enum(RecipeType.class);
        NBT_TYPE = BinaryTagSerializer.fromEnumKeyed(RecipeType.class);
    }
}

