/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biomes;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.world.biomes.Biome;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTType;

public final class BiomeManager {
    private final Map<Integer, Biome> biomes = new ConcurrentHashMap<Integer, Biome>();

    public BiomeManager() {
        this.addBiome(Biome.PLAINS);
    }

    public void addBiome(Biome biome) {
        this.biomes.put(biome.id(), biome);
    }

    public void removeBiome(Biome biome) {
        this.biomes.remove(biome.id());
    }

    public Collection<Biome> unmodifiableCollection() {
        return Collections.unmodifiableCollection(this.biomes.values());
    }

    public Biome getById(int id) {
        return this.biomes.get(id);
    }

    public Biome getByName(NamespaceID namespaceID) {
        Biome biome = null;
        for (Biome biomeT : this.biomes.values()) {
            if (!biomeT.name().equals(namespaceID)) continue;
            biome = biomeT;
            break;
        }
        return biome;
    }

    public NBTCompound toNBT() {
        return NBT.Compound(Map.of("type", NBT.String((String)"minecraft:worldgen/biome"), "value", NBT.List((NBTType)NBTType.TAG_Compound, this.biomes.values().stream().map(Biome::toNbt).toList())));
    }
}

