/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record MapDataPacket(int mapId, byte scale, boolean locked, boolean trackingPosition, @NotNull List<Icon> icons, @Nullable ColorContent colorContent) implements ServerPacket
{
    public MapDataPacket(int mapId, byte scale, boolean locked, boolean trackingPosition, @NotNull List<Icon> icons, @Nullable ColorContent colorContent) {
        icons = List.copyOf(icons);
    }

    public MapDataPacket(@NotNull NetworkBuffer reader) {
        this(MapDataPacket.read(reader));
    }

    private MapDataPacket(MapDataPacket packet) {
        this(packet.mapId, packet.scale, packet.locked, packet.trackingPosition, packet.icons, packet.colorContent);
    }

    private static MapDataPacket read(@NotNull NetworkBuffer reader) {
        Integer mapId = reader.read(NetworkBuffer.VAR_INT);
        Byte scale = reader.read(NetworkBuffer.BYTE);
        Boolean locked = reader.read(NetworkBuffer.BOOLEAN);
        Boolean trackingPosition = reader.read(NetworkBuffer.BOOLEAN);
        List<Icon> icons = trackingPosition != false ? reader.readCollection(Icon::new) : List.of();
        Byte columns = reader.read(NetworkBuffer.BYTE);
        if (columns <= 0) {
            return new MapDataPacket(mapId, scale, locked, trackingPosition, icons, null);
        }
        byte rows = reader.read(NetworkBuffer.BYTE);
        byte x = reader.read(NetworkBuffer.BYTE);
        byte z = reader.read(NetworkBuffer.BYTE);
        byte[] data = reader.read(NetworkBuffer.BYTE_ARRAY);
        return new MapDataPacket(mapId, scale, locked, trackingPosition, icons, new ColorContent(columns, rows, x, z, data));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.mapId);
        writer.write(NetworkBuffer.BYTE, this.scale);
        writer.write(NetworkBuffer.BOOLEAN, this.locked);
        writer.write(NetworkBuffer.BOOLEAN, this.trackingPosition);
        if (this.trackingPosition) {
            writer.writeCollection(this.icons);
        }
        if (this.colorContent != null) {
            writer.write(this.colorContent);
        } else {
            writer.write(NetworkBuffer.BYTE, (byte)0);
        }
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.MAP_DATA;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    public record ColorContent(byte columns, byte rows, byte x, byte z, byte @NotNull [] data) implements NetworkBuffer.Writer
    {
        public ColorContent(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.BYTE_ARRAY));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.BYTE, this.columns);
            writer.write(NetworkBuffer.BYTE, this.rows);
            writer.write(NetworkBuffer.BYTE, this.x);
            writer.write(NetworkBuffer.BYTE, this.z);
            writer.write(NetworkBuffer.BYTE_ARRAY, this.data);
        }
    }

    public record Icon(int type, byte x, byte z, byte direction, @Nullable Component displayName) implements NetworkBuffer.Writer
    {
        public Icon(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.BOOLEAN) != false ? reader.read(NetworkBuffer.COMPONENT) : null);
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.type);
            writer.write(NetworkBuffer.BYTE, this.x);
            writer.write(NetworkBuffer.BYTE, this.z);
            writer.write(NetworkBuffer.BYTE, this.direction);
            writer.write(NetworkBuffer.BOOLEAN, this.displayName != null);
            if (this.displayName != null) {
                writer.write(NetworkBuffer.COMPONENT, this.displayName);
            }
        }
    }
}

