/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DamageEventPacket(int targetEntityId, int damageTypeId, int sourceEntityId, int sourceDirectId, @Nullable Point sourcePos) implements ServerPacket
{
    public DamageEventPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT), reader.readOptional(NetworkBuffer.VECTOR3D));
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.DAMAGE_EVENT;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.targetEntityId);
        writer.write(NetworkBuffer.VAR_INT, this.damageTypeId);
        writer.write(NetworkBuffer.VAR_INT, this.sourceEntityId);
        writer.write(NetworkBuffer.VAR_INT, this.sourceDirectId);
        writer.writeOptional(NetworkBuffer.VECTOR3D, this.sourcePos);
    }
}

