/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minestom.server.entity.Player;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public final class ClientInteractEntityPacket
extends Record
implements ClientPacket {
    private final int targetId;
    @NotNull
    private final Type type;
    private final boolean sneaking;

    public ClientInteractEntityPacket(@NotNull NetworkBuffer reader) {
        int n = reader.read(NetworkBuffer.VAR_INT);
        this(n, (Type)((Object)(switch (reader.read(NetworkBuffer.VAR_INT)) {
            case 0 -> new Interact(reader);
            case 1 -> new Attack();
            case 2 -> new InteractAt(reader);
            default -> throw new RuntimeException("Unknown action id");
        })), reader.read(NetworkBuffer.BOOLEAN));
    }

    public ClientInteractEntityPacket(int targetId, @NotNull Type type, boolean sneaking) {
        this.targetId = targetId;
        this.type = type;
        this.sneaking = sneaking;
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.targetId);
        writer.write(NetworkBuffer.VAR_INT, this.type.id());
        writer.write(this.type);
        writer.write(NetworkBuffer.BOOLEAN, this.sneaking);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClientInteractEntityPacket.class, "targetId;type;sneaking", "targetId", "type", "sneaking"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClientInteractEntityPacket.class, "targetId;type;sneaking", "targetId", "type", "sneaking"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClientInteractEntityPacket.class, "targetId;type;sneaking", "targetId", "type", "sneaking"}, this, o);
    }

    public int targetId() {
        return this.targetId;
    }

    @NotNull
    public Type type() {
        return this.type;
    }

    public boolean sneaking() {
        return this.sneaking;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Type
    extends NetworkBuffer.Writer {
        public int id();
    }

    public record Interact(@NotNull Player.Hand hand) implements Type
    {
        public Interact(@NotNull NetworkBuffer reader) {
            this(reader.readEnum(Player.Hand.class));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.writeEnum(Player.Hand.class, this.hand);
        }

        @Override
        public int id() {
            return 0;
        }
    }

    public record Attack() implements Type
    {
        @Override
        public void write(@NotNull NetworkBuffer writer) {
        }

        @Override
        public int id() {
            return 1;
        }
    }

    public record InteractAt(float targetX, float targetY, float targetZ, @NotNull Player.Hand hand) implements Type
    {
        public InteractAt(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.readEnum(Player.Hand.class));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.targetX));
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.targetY));
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.targetZ));
            writer.writeEnum(Player.Hand.class, this.hand);
        }

        @Override
        public int id() {
            return 2;
        }
    }
}

