/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minestom.server.MinecraftServer;
import net.minestom.server.collision.Shape;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.DynamicChunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.light.Light;
import net.minestom.server.instance.light.LightCompute;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.play.UpdateLightPacket;
import net.minestom.server.network.packet.server.play.data.LightData;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

public class LightingChunk
extends DynamicChunk {
    private static final ExecutorService pool = Executors.newWorkStealingPool();
    private int[] heightmap;
    final CachedPacket lightCache = new CachedPacket(this::createLightPacket);
    boolean chunkLoaded = false;
    private int highestBlock;
    private boolean initialLightingSent = false;
    private static final Set<NamespaceID> DIFFUSE_SKY_LIGHT = Set.of(Block.COBWEB.namespace(), Block.ICE.namespace(), Block.HONEY_BLOCK.namespace(), Block.SLIME_BLOCK.namespace(), Block.WATER.namespace(), Block.ACACIA_LEAVES.namespace(), Block.AZALEA_LEAVES.namespace(), Block.BIRCH_LEAVES.namespace(), Block.DARK_OAK_LEAVES.namespace(), Block.FLOWERING_AZALEA_LEAVES.namespace(), Block.JUNGLE_LEAVES.namespace(), Block.OAK_LEAVES.namespace(), Block.SPRUCE_LEAVES.namespace(), Block.SPAWNER.namespace(), Block.BEACON.namespace(), Block.END_GATEWAY.namespace(), Block.CHORUS_PLANT.namespace(), Block.CHORUS_FLOWER.namespace(), Block.FROSTED_ICE.namespace(), Block.SEAGRASS.namespace(), Block.TALL_SEAGRASS.namespace(), Block.LAVA.namespace());

    public LightingChunk(@NotNull Instance instance, int chunkX, int chunkZ) {
        super(instance, chunkX, chunkZ);
    }

    private boolean checkSkyOcclusion(Block block) {
        if (block == Block.AIR) {
            return false;
        }
        if (DIFFUSE_SKY_LIGHT.contains(block.namespace())) {
            return true;
        }
        Shape shape = block.registry().collisionShape();
        boolean occludesTop = Block.AIR.registry().collisionShape().isOccluded(shape, BlockFace.TOP);
        boolean occludesBottom = Block.AIR.registry().collisionShape().isOccluded(shape, BlockFace.BOTTOM);
        return occludesBottom || occludesTop;
    }

    private void invalidateSection(int coordinate) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                Chunk neighborChunk = this.instance.getChunk(this.chunkX + i, this.chunkZ + j);
                if (neighborChunk == null) continue;
                if (neighborChunk instanceof LightingChunk) {
                    LightingChunk light = (LightingChunk)neighborChunk;
                    light.lightCache.invalidate();
                    light.chunkCache.invalidate();
                }
                for (int k = -1; k <= 1; ++k) {
                    if (k + coordinate < neighborChunk.getMinSection() || k + coordinate >= neighborChunk.getMaxSection()) continue;
                    neighborChunk.getSection(k + coordinate).blockLight().invalidate();
                    neighborChunk.getSection(k + coordinate).skyLight().invalidate();
                }
            }
        }
    }

    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block, @Nullable BlockHandler.Placement placement, @Nullable BlockHandler.Destroy destroy) {
        super.setBlock(x, y, z, block, placement, destroy);
        this.heightmap = null;
        int coordinate = ChunkUtils.getChunkCoordinate(y);
        if (this.chunkLoaded) {
            this.invalidateSection(coordinate);
            this.lightCache.invalidate();
        }
    }

    public void sendLighting() {
        if (!this.isLoaded()) {
            return;
        }
        this.sendPacketToViewers(this.lightCache);
    }

    @Override
    protected void onLoad() {
        this.chunkLoaded = true;
    }

    public boolean isLightingCalculated() {
        return this.initialLightingSent;
    }

    @Override
    protected NBTCompound computeHeightmap() {
        int[] heightmap = this.getHeightmap();
        int dimensionHeight = this.getInstance().getDimensionType().getHeight();
        int bitsForHeight = MathUtils.bitsToRepresent(dimensionHeight);
        return NBT.Compound(Map.of("MOTION_BLOCKING", NBT.LongArray((long[])LightingChunk.encodeBlocks(heightmap, bitsForHeight)), "WORLD_SURFACE", NBT.LongArray((long[])LightingChunk.encodeBlocks(heightmap, bitsForHeight))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getHeightmap() {
        if (this.heightmap != null) {
            return this.heightmap;
        }
        int[] heightmap = new int[256];
        int minY = this.instance.getDimensionType().getMinY();
        int maxY = this.instance.getDimensionType().getMinY() + this.instance.getDimensionType().getHeight();
        this.highestBlock = minY;
        LightingChunk lightingChunk = this;
        synchronized (lightingChunk) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Block block;
                    int height;
                    for (height = maxY; height > minY && !this.checkSkyOcclusion(block = this.getBlock(x, height, z, Block.Getter.Condition.TYPE)); --height) {
                    }
                    heightmap[z << 4 | x] = height + 1;
                    if (height <= this.highestBlock) continue;
                    this.highestBlock = height;
                }
            }
        }
        this.heightmap = heightmap;
        return heightmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LightData createLightData() {
        if (this.lightCache.isValid()) {
            ServerPacket packet = this.lightCache.packet(ConnectionState.PLAY);
            return ((UpdateLightPacket)packet).lightData();
        }
        CachedPacket cachedPacket = this.lightCache;
        synchronized (cachedPacket) {
            BitSet skyMask = new BitSet();
            BitSet blockMask = new BitSet();
            BitSet emptySkyMask = new BitSet();
            BitSet emptyBlockMask = new BitSet();
            ArrayList<byte[]> skyLights = new ArrayList<byte[]>();
            ArrayList<byte[]> blockLights = new ArrayList<byte[]>();
            HashSet<Chunk> combined = new HashSet<Chunk>();
            int chunkMin = this.instance.getDimensionType().getMinY();
            int index = 0;
            for (Section section : this.sections) {
                Set<Chunk> needsSend;
                boolean wasUpdatedBlock = false;
                boolean wasUpdatedSky = false;
                if (section.blockLight().requiresUpdate()) {
                    needsSend = LightingChunk.relightSection(this.instance, this.chunkX, index + this.minSection, this.chunkZ, LightType.BLOCK);
                    combined.addAll(needsSend);
                    wasUpdatedBlock = true;
                } else if (section.blockLight().requiresSend()) {
                    wasUpdatedBlock = true;
                }
                if (section.skyLight().requiresUpdate()) {
                    needsSend = LightingChunk.relightSection(this.instance, this.chunkX, index + this.minSection, this.chunkZ, LightType.SKY);
                    combined.addAll(needsSend);
                    wasUpdatedSky = true;
                } else if (section.skyLight().requiresSend()) {
                    wasUpdatedSky = true;
                }
                byte[] skyLight = section.skyLight().array();
                byte[] blockLight = section.blockLight().array();
                int sectionMaxY = ++index * 16 + chunkMin;
                if (wasUpdatedSky && this.instance.getDimensionType().isSkylightEnabled() && sectionMaxY <= this.highestBlock + 16) {
                    if (skyLight.length != 0 && skyLight != LightCompute.emptyContent) {
                        skyLights.add(skyLight);
                        skyMask.set(index);
                    } else {
                        emptySkyMask.set(index);
                    }
                }
                if (!wasUpdatedBlock) continue;
                if (blockLight.length != 0 && blockLight != LightCompute.emptyContent) {
                    blockLights.add(blockLight);
                    blockMask.set(index);
                    continue;
                }
                emptyBlockMask.set(index);
            }
            MinecraftServer.getSchedulerManager().scheduleNextTick(() -> {
                for (Chunk chunk : combined) {
                    if (!(chunk instanceof LightingChunk)) continue;
                    LightingChunk light = (LightingChunk)chunk;
                    if (!light.initialLightingSent) continue;
                    light.lightCache.invalidate();
                    light.chunkCache.invalidate();
                    this.lightCache.body(ConnectionState.PLAY);
                    light.sendLighting();
                    light.sections.forEach(s -> {
                        s.blockLight().setRequiresSend(true);
                        s.skyLight().setRequiresSend(true);
                    });
                }
                this.initialLightingSent = true;
            });
            return new LightData(skyMask, blockMask, emptySkyMask, emptyBlockMask, skyLights, blockLights);
        }
    }

    private static Set<Chunk> flushQueue(Instance instance, Set<Point> queue, LightType type, QueueType queueType) {
        ConcurrentHashMap.KeySetView sections = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView newQueue = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView responseChunks = ConcurrentHashMap.newKeySet();
        ArrayList<CompletableFuture<Void>> tasks = new ArrayList<CompletableFuture<Void>>();
        for (Point point : queue) {
            Chunk chunk = instance.getChunk(point.blockX(), point.blockZ());
            if (chunk == null) continue;
            Section section = chunk.getSection(point.blockY());
            responseChunks.add(chunk);
            Light light = type == LightType.BLOCK ? section.blockLight() : section.skyLight();
            CompletableFuture<Void> task = CompletableFuture.runAsync(() -> {
                if (queueType == QueueType.INTERNAL) {
                    light.calculateInternal(instance, chunk.getChunkX(), point.blockY(), chunk.getChunkZ());
                } else {
                    light.calculateExternal(instance, chunk, point.blockY());
                }
                sections.add(light);
                Set<Point> toAdd = light.flip();
                if (toAdd != null) {
                    newQueue.addAll(toAdd);
                }
            }, pool);
            tasks.add(task);
        }
        tasks.forEach(CompletableFuture::join);
        if (!newQueue.isEmpty()) {
            Set<Chunk> newResponse = LightingChunk.flushQueue(instance, newQueue, type, QueueType.EXTERNAL);
            responseChunks.addAll(newResponse);
        }
        return responseChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void relight(Instance instance, Collection<Chunk> chunks) {
        HashSet<Point> sections = new HashSet<Point>();
        for (Chunk chunk : chunks) {
            if (chunk == null) continue;
            for (int section = chunk.minSection; section < chunk.maxSection; ++section) {
                if (!(chunk instanceof LightingChunk)) continue;
                chunk.getSection(section).blockLight().invalidate();
                chunk.getSection(section).skyLight().invalidate();
                sections.add(new Vec(chunk.getChunkX(), section, chunk.getChunkZ()));
            }
        }
        Instance instance2 = instance;
        synchronized (instance2) {
            LightingChunk.relight(instance, sections, LightType.BLOCK);
            LightingChunk.relight(instance, sections, LightType.SKY);
        }
    }

    private static Set<Point> getNearbyRequired(Instance instance, Point point, LightType type) {
        Chunk chunkCheck;
        int z;
        int x;
        HashSet<Point> collected = new HashSet<Point>();
        collected.add(point);
        int highestRegionPoint = instance.getDimensionType().getMinY();
        for (x = point.blockX() - 1; x <= point.blockX() + 1; ++x) {
            for (z = point.blockZ() - 1; z <= point.blockZ() + 1; ++z) {
                chunkCheck = instance.getChunk(x, z);
                if (chunkCheck == null || !(chunkCheck instanceof LightingChunk)) continue;
                LightingChunk lighting = (LightingChunk)chunkCheck;
                lighting.getHeightmap();
                if (lighting.highestBlock <= highestRegionPoint) continue;
                highestRegionPoint = lighting.highestBlock;
            }
        }
        for (x = point.blockX() - 1; x <= point.blockX() + 1; ++x) {
            for (z = point.blockZ() - 1; z <= point.blockZ() + 1; ++z) {
                chunkCheck = instance.getChunk(x, z);
                if (chunkCheck == null) continue;
                for (int y = point.blockY() - 1; y <= point.blockY() + 1; ++y) {
                    Section s;
                    Vec sectionPosition = new Vec(x, y, z);
                    int sectionHeight = instance.getDimensionType().getMinY() + 16 * y;
                    if (sectionHeight + 16 > highestRegionPoint && type == LightType.SKY || sectionPosition.blockY() >= chunkCheck.getMaxSection() || sectionPosition.blockY() < chunkCheck.getMinSection() || !(s = chunkCheck.getSection(sectionPosition.blockY())).blockLight().requiresUpdate() && !s.skyLight().requiresUpdate()) continue;
                    collected.add(sectionPosition);
                }
            }
        }
        return collected;
    }

    private static Set<Point> collectRequiredNearby(Instance instance, Point point, LightType type) {
        HashSet<Point> found = new HashSet<Point>();
        ArrayDeque<Point> toCheck = new ArrayDeque<Point>();
        toCheck.add(point);
        found.add(point);
        while (!toCheck.isEmpty()) {
            Point current = (Point)toCheck.poll();
            Set<Point> nearby = LightingChunk.getNearbyRequired(instance, current, type);
            nearby.forEach(p -> {
                if (!found.contains(p)) {
                    found.add((Point)p);
                    toCheck.add((Point)p);
                }
            });
        }
        return found;
    }

    static Set<Chunk> relightSection(Instance instance, int chunkX, int sectionY, int chunkZ) {
        HashSet<Chunk> res = new HashSet<Chunk>(LightingChunk.relightSection(instance, chunkX, sectionY, chunkZ, LightType.BLOCK));
        res.addAll(LightingChunk.relightSection(instance, chunkX, sectionY, chunkZ, LightType.SKY));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Chunk> relightSection(Instance instance, int chunkX, int sectionY, int chunkZ, LightType type) {
        Chunk c = instance.getChunk(chunkX, chunkZ);
        if (c == null) {
            return Set.of();
        }
        Instance instance2 = instance;
        synchronized (instance2) {
            Set<Point> collected = LightingChunk.collectRequiredNearby(instance, new Vec(chunkX, sectionY, chunkZ), type);
            return LightingChunk.relight(instance, collected, type);
        }
    }

    private static Set<Chunk> relight(Instance instance, Set<Point> queue, LightType type) {
        return LightingChunk.flushQueue(instance, queue, type, QueueType.INTERNAL);
    }

    @Override
    @NotNull
    public Chunk copy(@NotNull Instance instance, int chunkX, int chunkZ) {
        LightingChunk lightingChunk = new LightingChunk(instance, chunkX, chunkZ);
        lightingChunk.sections = this.sections.stream().map(Section::clone).toList();
        lightingChunk.entries.putAll((Map)this.entries);
        return lightingChunk;
    }

    static enum LightType {
        SKY,
        BLOCK;

    }

    private static enum QueueType {
        INTERNAL,
        EXTERNAL;

    }
}

