/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.damage;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.registry.Registry;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTType;

record DamageTypeImpl(Registry.DamageTypeEntry registry, int id) implements DamageType
{
    private static final Registry.Container<DamageType> CONTAINER;
    private static NBTCompound lazyNbt;

    static DamageType get(@NotNull String namespace) {
        return CONTAINER.get(namespace);
    }

    static DamageType getSafe(@NotNull String namespace) {
        return CONTAINER.getSafe(namespace);
    }

    static DamageType getId(int id) {
        return CONTAINER.getId(id);
    }

    @Override
    public NBTCompound asNBT() {
        HashMap<String, Object> elem = new HashMap<String, Object>();
        elem.put("exhaustion", NBT.Float((float)this.registry.exhaustion()));
        elem.put("message_id", NBT.String((String)this.registry.messageId()));
        elem.put("scaling", NBT.String((String)this.registry.scaling()));
        return NBT.Compound(elem);
    }

    static Collection<DamageType> values() {
        return CONTAINER.values();
    }

    @Override
    public String toString() {
        return this.name();
    }

    static NBTCompound getNBT() {
        if (lazyNbt == null) {
            List<NBTCompound> damageTypes = DamageTypeImpl.values().stream().map(damageType -> NBT.Compound(Map.of("id", NBT.Int((int)damageType.id()), "name", NBT.String((String)damageType.name()), "element", damageType.asNBT()))).toList();
            lazyNbt = NBT.Compound(Map.of("type", NBT.String((String)"minecraft:damage_type"), "value", NBT.List((NBTType)NBTType.TAG_Compound, damageTypes)));
        }
        return lazyNbt;
    }

    static {
        AtomicInteger i = new AtomicInteger();
        CONTAINER = Registry.createContainer(Registry.Resource.DAMAGE_TYPES, (namespace, properties) -> new DamageTypeImpl(Registry.damageType(namespace, properties), i.getAndIncrement()));
        lazyNbt = null;
    }
}

