/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.scoreboard;

import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minestom.server.entity.Player;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.play.DisplayScoreboardPacket;
import net.minestom.server.network.packet.server.play.ResetScorePacket;
import net.minestom.server.network.packet.server.play.ScoreboardObjectivePacket;
import net.minestom.server.network.packet.server.play.TeamsPacket;
import net.minestom.server.network.packet.server.play.UpdateScorePacket;
import net.minestom.server.scoreboard.Scoreboard;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Sidebar
implements Scoreboard {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final String SCOREBOARD_PREFIX = "sb-";
    private static final String TEAM_PREFIX = "sbt-";
    private static final int MAX_LINES_COUNT = 15;
    private final Set<Player> viewers = new CopyOnWriteArraySet<Player>();
    private final Set<ScoreboardLine> lines = new CopyOnWriteArraySet<ScoreboardLine>();
    private final IntLinkedOpenHashSet availableColors = new IntLinkedOpenHashSet();
    private final String objectiveName;
    private Component title;

    @Deprecated
    public Sidebar(@NotNull String title) {
        this((Component)Component.text((String)title));
    }

    public Sidebar(@NotNull Component title) {
        this.title = title;
        this.objectiveName = SCOREBOARD_PREFIX + COUNTER.incrementAndGet();
        for (int i = 0; i < 16; ++i) {
            this.availableColors.add(i);
        }
    }

    @Deprecated
    public void setTitle(@NotNull String title) {
        this.setTitle((Component)Component.text((String)title));
    }

    public void setTitle(@NotNull Component title) {
        this.title = title;
        this.sendPacketToViewers(new ScoreboardObjectivePacket(this.objectiveName, 2, title, ScoreboardObjectivePacket.Type.INTEGER, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLine(@NotNull ScoreboardLine scoreboardLine) {
        Set<ScoreboardLine> set = this.lines;
        synchronized (set) {
            Check.stateCondition(this.lines.size() >= 15, "You cannot have more than 15  lines");
            Check.argCondition(this.lines.contains(scoreboardLine), "You cannot add two times the same ScoreboardLine");
            for (ScoreboardLine line : this.lines) {
                Check.argCondition(line.id.equals(scoreboardLine.id), "You cannot add two ScoreboardLine with the same id");
            }
            scoreboardLine.retrieveName(this.availableColors);
            scoreboardLine.createTeam();
            this.lines.add(scoreboardLine);
            this.sendPacketsToViewers(scoreboardLine.sidebarTeam.getCreationPacket(), scoreboardLine.getScoreCreationPacket(this.objectiveName));
        }
    }

    public void updateLineContent(@NotNull String id, @NotNull Component content) {
        ScoreboardLine scoreboardLine = this.getLine(id);
        if (scoreboardLine != null) {
            scoreboardLine.refreshContent(content);
            this.sendPacketToViewers(scoreboardLine.sidebarTeam.updatePrefix(content));
        }
    }

    public void updateLineScore(@NotNull String id, int score) {
        ScoreboardLine scoreboardLine = this.getLine(id);
        if (scoreboardLine != null) {
            scoreboardLine.line = score;
            this.sendPacketToViewers(scoreboardLine.getLineScoreUpdatePacket(this.objectiveName, score));
        }
    }

    @Nullable
    public ScoreboardLine getLine(@NotNull String id) {
        for (ScoreboardLine line : this.lines) {
            if (!line.id.equals(id)) continue;
            return line;
        }
        return null;
    }

    @NotNull
    public Set<ScoreboardLine> getLines() {
        return Collections.unmodifiableSet(this.lines);
    }

    public void removeLine(@NotNull String id) {
        this.lines.removeIf(line -> {
            if (line.id.equals(id)) {
                this.sendPacketsToViewers(line.getScoreDestructionPacket(this.objectiveName), line.sidebarTeam.getDestructionPacket());
                line.returnName(this.availableColors);
                return true;
            }
            return false;
        });
    }

    @Override
    public boolean addViewer(@NotNull Player player) {
        boolean result = this.viewers.add(player);
        if (result) {
            ScoreboardObjectivePacket scoreboardObjectivePacket = this.getCreationObjectivePacket(this.title, ScoreboardObjectivePacket.Type.INTEGER);
            player.sendPacket(scoreboardObjectivePacket);
        }
        DisplayScoreboardPacket displayScoreboardPacket = this.getDisplayScoreboardPacket((byte)1);
        player.sendPacket(displayScoreboardPacket);
        for (ScoreboardLine line : this.lines) {
            player.sendPacket(line.sidebarTeam.getCreationPacket());
            player.sendPacket(line.getScoreCreationPacket(this.objectiveName));
        }
        return result;
    }

    @Override
    public boolean removeViewer(@NotNull Player player) {
        boolean result = this.viewers.remove(player);
        if (!result) {
            return false;
        }
        ScoreboardObjectivePacket scoreboardObjectivePacket = this.getDestructionObjectivePacket();
        player.sendPacket(scoreboardObjectivePacket);
        for (ScoreboardLine line : this.lines) {
            player.sendPacket(line.getScoreDestructionPacket(this.objectiveName));
            player.sendPacket(line.sidebarTeam.getDestructionPacket());
        }
        return true;
    }

    @Override
    @NotNull
    public Set<Player> getViewers() {
        return Collections.unmodifiableSet(this.viewers);
    }

    @Override
    @NotNull
    public String getObjectiveName() {
        return this.objectiveName;
    }

    public record NumberFormat(FormatType formatType, Component content) {
        public static final NetworkBuffer.Type<NumberFormat> SERIALIZER = new NetworkBuffer.Type<NumberFormat>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, NumberFormat value) {
                buffer.write(NetworkBuffer.Enum(FormatType.class), value.formatType);
                if (value.formatType == FormatType.STYLED) {
                    assert (value.content != null);
                    buffer.write(NetworkBuffer.COMPONENT, value.content);
                } else if (value.formatType == FormatType.FIXED) {
                    assert (value.content != null);
                    buffer.write(NetworkBuffer.COMPONENT, value.content);
                }
            }

            @Override
            public NumberFormat read(@NotNull NetworkBuffer buffer) {
                FormatType formatType = buffer.read(NetworkBuffer.Enum(FormatType.class));
                Component content = formatType != FormatType.BLANK ? buffer.read(NetworkBuffer.COMPONENT) : null;
                return new NumberFormat(formatType, content);
            }
        };

        private NumberFormat() {
            this(FormatType.BLANK, null);
        }

        @NotNull
        public static NumberFormat blank() {
            return new NumberFormat();
        }

        @NotNull
        public static NumberFormat styled(@NotNull Component style) {
            return new NumberFormat(FormatType.STYLED, style);
        }

        @NotNull
        public static NumberFormat fixed(@NotNull Component content) {
            return new NumberFormat(FormatType.FIXED, content);
        }

        private static enum FormatType {
            BLANK,
            STYLED,
            FIXED;

        }
    }

    public static class ScoreboardLine {
        private final String id;
        private final Component content;
        private int line;
        private NumberFormat numberFormat;
        private final String teamName;
        private int colorName;
        private String entityName;
        private SidebarTeam sidebarTeam;

        public ScoreboardLine(@NotNull String id, @NotNull Component content, int line) {
            this(id, content, line, null);
        }

        public ScoreboardLine(@NotNull String id, @NotNull Component content, int line, @Nullable NumberFormat numberFormat) {
            this.id = id;
            this.content = content;
            this.line = line;
            this.numberFormat = numberFormat;
            this.teamName = Sidebar.TEAM_PREFIX + COUNTER.incrementAndGet();
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public Component getContent() {
            return this.sidebarTeam == null ? this.content : this.sidebarTeam.getPrefix();
        }

        public int getLine() {
            return this.line;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void retrieveName(IntLinkedOpenHashSet colors) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = colors;
            synchronized (intLinkedOpenHashSet) {
                this.colorName = colors.removeFirstInt();
            }
        }

        private void createTeam() {
            this.entityName = "\u00a7" + Integer.toHexString(this.colorName);
            this.sidebarTeam = new SidebarTeam(this.teamName, this.content, (Component)Component.empty(), this.entityName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void returnName(IntLinkedOpenHashSet colors) {
            IntLinkedOpenHashSet intLinkedOpenHashSet = colors;
            synchronized (intLinkedOpenHashSet) {
                colors.add(this.colorName);
            }
        }

        private UpdateScorePacket getScoreCreationPacket(String objectiveName) {
            return new UpdateScorePacket(this.entityName, objectiveName, this.line, (Component)Component.empty(), this.numberFormat);
        }

        private ResetScorePacket getScoreDestructionPacket(String objectiveName) {
            return new ResetScorePacket(this.entityName, objectiveName);
        }

        private UpdateScorePacket getLineScoreUpdatePacket(String objectiveName, int score) {
            return new UpdateScorePacket(this.entityName, objectiveName, score, (Component)Component.empty(), this.numberFormat);
        }

        private void refreshContent(Component content) {
            this.sidebarTeam.refreshPrefix(content);
        }
    }

    private static class SidebarTeam {
        private final String teamName;
        private Component prefix;
        private Component suffix;
        private final String entityName;
        private final Component teamDisplayName = Component.text((String)"displaynametest");
        private final byte friendlyFlags = 0;
        private final TeamsPacket.NameTagVisibility nameTagVisibility = TeamsPacket.NameTagVisibility.NEVER;
        private final TeamsPacket.CollisionRule collisionRule = TeamsPacket.CollisionRule.NEVER;
        private final NamedTextColor teamColor = NamedTextColor.WHITE;

        private SidebarTeam(String teamName, Component prefix, Component suffix, String entityName) {
            this.teamName = teamName;
            this.prefix = prefix;
            this.suffix = suffix;
            this.entityName = entityName;
        }

        private TeamsPacket getCreationPacket() {
            TeamsPacket.CreateTeamAction action = new TeamsPacket.CreateTeamAction(this.teamDisplayName, 0, this.nameTagVisibility, this.collisionRule, this.teamColor, this.prefix, this.suffix, List.of(this.entityName));
            return new TeamsPacket(this.teamName, action);
        }

        private TeamsPacket getDestructionPacket() {
            return new TeamsPacket(this.teamName, new TeamsPacket.RemoveTeamAction());
        }

        private TeamsPacket updatePrefix(Component prefix) {
            TeamsPacket.UpdateTeamAction action = new TeamsPacket.UpdateTeamAction(this.teamDisplayName, 0, this.nameTagVisibility, this.collisionRule, this.teamColor, prefix, this.suffix);
            return new TeamsPacket(this.teamName, action);
        }

        private String getEntityName() {
            return this.entityName;
        }

        private Component getPrefix() {
            return this.prefix;
        }

        private void refreshPrefix(@NotNull Component prefix) {
            this.prefix = prefix;
        }
    }
}

