/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record FacePlayerPacket(FacePosition facePosition, Point target, int entityId, FacePosition entityFacePosition) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<FacePlayerPacket> SERIALIZER = new NetworkBuffer.Type<FacePlayerPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, @NotNull FacePlayerPacket value) {
            buffer.write(NetworkBuffer.Enum(FacePosition.class), value.facePosition);
            buffer.write(NetworkBuffer.VECTOR3D, value.target);
            boolean isEntity = value.entityId > 0;
            buffer.write(NetworkBuffer.BOOLEAN, isEntity);
            if (isEntity) {
                buffer.write(NetworkBuffer.VAR_INT, value.entityId);
                buffer.write(NetworkBuffer.Enum(FacePosition.class), value.entityFacePosition);
            }
        }

        @Override
        @NotNull
        public FacePlayerPacket read(@NotNull NetworkBuffer buffer) {
            return new FacePlayerPacket(buffer.read(NetworkBuffer.Enum(FacePosition.class)), buffer.read(NetworkBuffer.VECTOR3D), buffer.read(NetworkBuffer.BOOLEAN) != false ? buffer.read(NetworkBuffer.VAR_INT) : 0, buffer.readableBytes() > 0L ? buffer.read(NetworkBuffer.Enum(FacePosition.class)) : null);
        }
    };

    public static enum FacePosition {
        FEET,
        EYES;

    }
}

