/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.map.framebuffers;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import net.minestom.server.map.Framebuffer;
import net.minestom.server.map.LargeFramebuffer;
import net.minestom.server.map.MapColors;
import net.minestom.server.map.framebuffers.LargeFramebufferDefaultView;

public class LargeGraphics2DFramebuffer
implements LargeFramebuffer {
    private final BufferedImage backingImage;
    private final Graphics2D renderer;
    private final int[] pixels;
    private final int width;
    private final int height;

    public LargeGraphics2DFramebuffer(int width, int height) {
        this.width = width;
        this.height = height;
        this.backingImage = new BufferedImage(width, height, 1);
        this.renderer = this.backingImage.createGraphics();
        this.pixels = ((DataBufferInt)this.backingImage.getRaster().getDataBuffer()).getData();
    }

    public Graphics2D getRenderer() {
        return this.renderer;
    }

    public BufferedImage getBackingImage() {
        return this.backingImage;
    }

    public int get(int x, int z) {
        return this.pixels[x + z * this.width];
    }

    public LargeGraphics2DFramebuffer set(int x, int z, int rgb) {
        this.pixels[x + z * this.width] = rgb;
        return this;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public Framebuffer createSubView(int left, int top) {
        return new LargeFramebufferDefaultView(this, left, top);
    }

    @Override
    public byte getMapColor(int x, int y) {
        return MapColors.closestColor(this.get(x, y)).getIndex();
    }
}

