/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.MinecraftServer;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.ArmorTrim;
import net.minestom.server.item.component.AttributeList;
import net.minestom.server.item.component.BlockPredicates;
import net.minestom.server.item.component.CustomData;
import net.minestom.server.item.component.DyedItemColor;
import net.minestom.server.item.component.EnchantmentList;
import net.minestom.server.item.component.JukeboxPlayable;
import net.minestom.server.item.component.Unbreakable;
import net.minestom.server.tag.Tag;
import net.minestom.server.utils.Unit;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

record ItemStackImpl(Material material, int amount, DataComponentMap components) implements ItemStack
{
    public ItemStackImpl {
        Check.notNull(material, "Material cannot be null");
        components = DataComponentMap.diff(material.prototype(), components);
    }

    static ItemStack create(Material material, int amount, DataComponentMap components) {
        if (amount <= 0) {
            return AIR;
        }
        return new ItemStackImpl(material, amount, components);
    }

    static ItemStack create(Material material, int amount) {
        return ItemStackImpl.create(material, amount, DataComponentMap.EMPTY);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull DataComponent<T> component) {
        return this.components.get(this.material.prototype(), component);
    }

    @Override
    public boolean has(@NotNull DataComponent<?> component) {
        return this.components.has(this.material.prototype(), component);
    }

    @Override
    @NotNull
    public ItemStack with(@NotNull @NotNull Consumer<@NotNull ItemStack.Builder> consumer) {
        ItemStack.Builder builder = this.builder();
        consumer.accept(builder);
        return builder.build();
    }

    @Override
    @NotNull
    public ItemStack withMaterial(@NotNull Material material) {
        return new ItemStackImpl(material, this.amount, this.components);
    }

    @Override
    @NotNull
    public ItemStack withAmount(int amount) {
        if (amount <= 0) {
            return ItemStack.AIR;
        }
        return ItemStackImpl.create(this.material, amount, this.components);
    }

    @Override
    @NotNull
    public <T> ItemStack with(@NotNull DataComponent<T> component, @NotNull T value) {
        return new ItemStackImpl(this.material, this.amount, this.components.set(component, value));
    }

    @Override
    @NotNull
    public ItemStack without(@NotNull DataComponent<?> component) {
        if (this.get(component) == null) {
            return this;
        }
        return new ItemStackImpl(this.material, this.amount, this.components.remove(component));
    }

    @Override
    @NotNull
    public ItemStack consume(int amount) {
        return this.withAmount(this.amount() - amount);
    }

    @Override
    public boolean isSimilar(@NotNull ItemStack itemStack) {
        return this.material == itemStack.material() && this.components.equals(((ItemStackImpl)itemStack).components);
    }

    @Override
    @NotNull
    public CompoundBinaryTag toItemNBT() {
        return (CompoundBinaryTag)NBT_TYPE.write(this);
    }

    @Override
    @Contract(value="-> new", pure=true)
    @NotNull
    public ItemStack.Builder builder() {
        return new Builder(this.material, this.amount, this.components.toPatchBuilder());
    }

    @NotNull
    static ItemStack fromCompound(@NotNull CompoundBinaryTag tag) {
        String id = tag.getString("id");
        Material material = Material.fromKey(id);
        Check.notNull(material, "Unknown material: {0}", id);
        int count = tag.getInt("count", 1);
        BinaryTagSerializer.ContextWithRegistries context = new BinaryTagSerializer.ContextWithRegistries(MinecraftServer.process(), false);
        DataComponentMap patch = ItemComponent.PATCH_NBT_TYPE.read(context, (BinaryTag)tag.getCompound("components"));
        return new ItemStackImpl(material, count, patch);
    }

    @NotNull
    static CompoundBinaryTag toCompound(@NotNull ItemStack itemStack) {
        CompoundBinaryTag.Builder tag = CompoundBinaryTag.builder();
        tag.putString("id", itemStack.material().name());
        tag.putInt("count", itemStack.amount());
        BinaryTagSerializer.ContextWithRegistries context = new BinaryTagSerializer.ContextWithRegistries(MinecraftServer.process(), false);
        CompoundBinaryTag components = (CompoundBinaryTag)ItemComponent.PATCH_NBT_TYPE.write(context, ((ItemStackImpl)itemStack).components);
        if (components.size() > 0) {
            tag.put("components", (BinaryTag)components);
        }
        return tag.build();
    }

    static final class Builder
    implements ItemStack.Builder {
        private Material material;
        private int amount;
        private DataComponentMap.PatchBuilder components;

        Builder(Material material, int amount, DataComponentMap.PatchBuilder components) {
            this.material = material;
            this.amount = amount;
            this.components = components;
        }

        Builder(Material material, int amount) {
            this.material = material;
            this.amount = amount;
            this.components = DataComponentMap.patchBuilder();
        }

        @Override
        public @NotNull ItemStack.Builder material(@NotNull Material material) {
            this.material = material;
            return this;
        }

        @Override
        public @NotNull ItemStack.Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        @Override
        public <T> @NotNull ItemStack.Builder set(@NotNull DataComponent<T> component, T value) {
            this.components.set(component, value);
            return this;
        }

        @Override
        public @NotNull ItemStack.Builder remove(@NotNull DataComponent<?> component) {
            this.components.remove(component);
            return this;
        }

        @Override
        public <T> @NotNull ItemStack.Builder set(@NotNull Tag<T> tag, @Nullable T value) {
            this.components.set(ItemComponent.CUSTOM_DATA, this.components.get(ItemComponent.CUSTOM_DATA, CustomData.EMPTY).withTag(tag, value));
            return this;
        }

        @Override
        public @NotNull ItemStack.Builder hideExtraTooltip() {
            JukeboxPlayable jukeboxPlayable;
            EnchantmentList enchantments;
            DyedItemColor dyedColor;
            BlockPredicates canPlaceOn;
            BlockPredicates canBreak;
            ArmorTrim armorTrim;
            AttributeList attributeModifiers = this.components.get(ItemComponent.ATTRIBUTE_MODIFIERS);
            this.components.set(ItemComponent.ATTRIBUTE_MODIFIERS, attributeModifiers == null ? new AttributeList(List.of(), false) : attributeModifiers.withTooltip(false));
            Unbreakable unbreakable = this.components.get(ItemComponent.UNBREAKABLE);
            if (unbreakable != null) {
                this.components.set(ItemComponent.UNBREAKABLE, new Unbreakable(false));
            }
            if ((armorTrim = this.components.get(ItemComponent.TRIM)) != null) {
                this.components.set(ItemComponent.TRIM, armorTrim.withTooltip(false));
            }
            if ((canBreak = this.components.get(ItemComponent.CAN_BREAK)) != null) {
                this.components.set(ItemComponent.CAN_BREAK, canBreak.withTooltip(false));
            }
            if ((canPlaceOn = this.components.get(ItemComponent.CAN_PLACE_ON)) != null) {
                this.components.set(ItemComponent.CAN_PLACE_ON, canPlaceOn.withTooltip(false));
            }
            if ((dyedColor = this.components.get(ItemComponent.DYED_COLOR)) != null) {
                this.components.set(ItemComponent.DYED_COLOR, dyedColor.withTooltip(false));
            }
            if ((enchantments = this.components.get(ItemComponent.ENCHANTMENTS)) != null) {
                this.components.set(ItemComponent.ENCHANTMENTS, enchantments.withTooltip(false));
            }
            if ((jukeboxPlayable = this.components.get(ItemComponent.JUKEBOX_PLAYABLE)) != null) {
                this.components.set(ItemComponent.JUKEBOX_PLAYABLE, jukeboxPlayable.withTooltip(false));
            }
            return this.set(ItemComponent.HIDE_ADDITIONAL_TOOLTIP, Unit.INSTANCE);
        }

        @Override
        @NotNull
        public ItemStack build() {
            return ItemStackImpl.create(this.material, this.amount, this.components.build());
        }
    }
}

