/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.jukebox;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.instance.block.jukebox.JukeboxSong;
import net.minestom.server.registry.Registry;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JukeboxSongImpl
extends Record
implements JukeboxSong {
    @NotNull
    private final SoundEvent soundEvent;
    @NotNull
    private final Component description;
    private final float lengthInSeconds;
    private final int comparatorOutput;
    @Nullable
    private final Registry.JukeboxSongEntry registry;
    static final BinaryTagSerializer<JukeboxSong> REGISTRY_NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        throw new UnsupportedOperationException("JukeboxSong is read-only");
    }, jukeboxSong -> ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("sound_event", jukeboxSong.soundEvent().name())).put("description", BinaryTagSerializer.NBT_COMPONENT.write(jukeboxSong.description()))).putFloat("length_in_seconds", jukeboxSong.lengthInSeconds())).putInt("comparator_output", jukeboxSong.comparatorOutput())).build());

    JukeboxSongImpl(@NotNull SoundEvent soundEvent, @NotNull Component description, float lengthInSeconds, int comparatorOutput, @Nullable Registry.JukeboxSongEntry registry) {
        Check.argCondition(soundEvent == null, "missing sound event");
        Check.argCondition(description == null, "missing description");
        this.soundEvent = soundEvent;
        this.description = description;
        this.lengthInSeconds = lengthInSeconds;
        this.comparatorOutput = comparatorOutput;
        this.registry = registry;
    }

    JukeboxSongImpl(@NotNull Registry.JukeboxSongEntry registry) {
        this(registry.soundEvent(), registry.description(), registry.lengthInSeconds(), registry.comparatorOutput(), registry);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{JukeboxSongImpl.class, "soundEvent;description;lengthInSeconds;comparatorOutput;registry", "soundEvent", "description", "lengthInSeconds", "comparatorOutput", "registry"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{JukeboxSongImpl.class, "soundEvent;description;lengthInSeconds;comparatorOutput;registry", "soundEvent", "description", "lengthInSeconds", "comparatorOutput", "registry"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{JukeboxSongImpl.class, "soundEvent;description;lengthInSeconds;comparatorOutput;registry", "soundEvent", "description", "lengthInSeconds", "comparatorOutput", "registry"}, this, o);
    }

    @Override
    @NotNull
    public SoundEvent soundEvent() {
        return this.soundEvent;
    }

    @Override
    @NotNull
    public Component description() {
        return this.description;
    }

    @Override
    public float lengthInSeconds() {
        return this.lengthInSeconds;
    }

    @Override
    public int comparatorOutput() {
        return this.comparatorOutput;
    }

    @Override
    @Nullable
    public Registry.JukeboxSongEntry registry() {
        return this.registry;
    }
}

