/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.anvil;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.nbt.TagStringIOExt;
import net.minestom.server.MinecraftServer;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.IChunkLoader;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.anvil.RegionFile;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.palette.Palettes;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnvilLoader
implements IChunkLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnvilLoader.class);
    private static final DynamicRegistry<Biome> BIOME_REGISTRY = MinecraftServer.getBiomeRegistry();
    private static final int PLAINS_ID = BIOME_REGISTRY.getId(Key.key((String)"minecraft:plains"));
    private final ReentrantLock fileCreationLock = new ReentrantLock();
    private final Map<String, RegionFile> alreadyLoaded = new ConcurrentHashMap<String, RegionFile>();
    private final Path path;
    private final Path levelPath;
    private final Path regionPath;
    private final RegionCache perRegionLoadedChunks = new RegionCache();
    private final ReentrantLock perRegionLoadedChunksLock = new ReentrantLock();
    private final ThreadLocal<Int2ObjectMap<CompoundBinaryTag>> blockStateId2ObjectCacheTLS = ThreadLocal.withInitial(Int2ObjectArrayMap::new);

    public AnvilLoader(@NotNull Path path) {
        this.path = path;
        this.levelPath = path.resolve("level.dat");
        this.regionPath = path.resolve("region");
    }

    public AnvilLoader(@NotNull String path) {
        this(Path.of(path, new String[0]));
    }

    @Override
    public void loadInstance(@NotNull Instance instance) {
        if (!Files.exists(this.levelPath, new LinkOption[0])) {
            return;
        }
        try (InputStream is = Files.newInputStream(this.levelPath, new OpenOption[0]);){
            CompoundBinaryTag tag = (CompoundBinaryTag)BinaryTagIO.reader().readNamed(is, BinaryTagIO.Compression.GZIP).getValue();
            Files.copy(this.levelPath, this.path.resolve("level.dat_old"), StandardCopyOption.REPLACE_EXISTING);
            instance.tagHandler().updateContent(tag);
        }
        catch (IOException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
    }

    @Override
    @Nullable
    public Chunk loadChunk(@NotNull Instance instance, int chunkX, int chunkZ) {
        if (!Files.exists(this.path, new LinkOption[0])) {
            return null;
        }
        try {
            return this.loadMCA(instance, chunkX, chunkZ);
        }
        catch (Exception e) {
            MinecraftServer.getExceptionManager().handleException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Chunk loadMCA(Instance instance, int chunkX, int chunkZ) throws IOException {
        Chunk chunk;
        RegionFile mcaFile = this.getMCAFile(chunkX, chunkZ);
        if (mcaFile == null) {
            return null;
        }
        CompoundBinaryTag chunkData = mcaFile.readChunkData(chunkX, chunkZ);
        if (chunkData == null) {
            return null;
        }
        Chunk chunk2 = chunk = instance.getChunkSupplier().createChunk(instance, chunkX, chunkZ);
        synchronized (chunk2) {
            String status = chunkData.getString("status");
            if (status.isEmpty() || "minecraft:full".equals(status)) {
                this.loadSections(chunk, chunkData);
                this.loadBlockEntities(chunk, chunkData);
                chunk.loadHeightmapsFromNBT(chunkData.getCompound("Heightmaps"));
            } else {
                LOGGER.warn("Skipping partially generated chunk at {}, {} with status {}", new Object[]{chunkX, chunkZ, status});
            }
        }
        this.perRegionLoadedChunksLock.lock();
        try {
            int regionX = CoordConversion.chunkToRegion(chunkX);
            int regionZ = CoordConversion.chunkToRegion(chunkZ);
            Set chunks = this.perRegionLoadedChunks.computeIfAbsent(new IntIntImmutablePair(regionX, regionZ), r -> new HashSet());
            chunks.add(new IntIntImmutablePair(chunkX, chunkZ));
        }
        finally {
            this.perRegionLoadedChunksLock.unlock();
        }
        return chunk;
    }

    @Nullable
    private RegionFile getMCAFile(int chunkX, int chunkZ) {
        int regionX = CoordConversion.chunkToRegion(chunkX);
        int regionZ = CoordConversion.chunkToRegion(chunkZ);
        return this.alreadyLoaded.computeIfAbsent(RegionFile.getFileName(regionX, regionZ), n -> {
            Path regionPath = this.regionPath.resolve((String)n);
            if (!Files.exists(regionPath, new LinkOption[0])) {
                return null;
            }
            this.perRegionLoadedChunksLock.lock();
            try {
                Set previousVersion = this.perRegionLoadedChunks.put(new IntIntImmutablePair(regionX, regionZ), new HashSet());
                assert (previousVersion == null) : "The AnvilLoader cache should not already have data for this region.";
                RegionFile regionFile = new RegionFile(regionPath);
                return regionFile;
            }
            catch (IOException e) {
                MinecraftServer.getExceptionManager().handleException(e);
                RegionFile regionFile = null;
                return regionFile;
            }
            finally {
                this.perRegionLoadedChunksLock.unlock();
            }
        });
    }

    private void loadSections(@NotNull Chunk chunk, @NotNull CompoundBinaryTag chunkData) {
        for (BinaryTag sectionTag : chunkData.getList("sections", BinaryTagTypes.COMPOUND)) {
            CompoundBinaryTag biomesTag;
            ListBinaryTag biomePaletteTag;
            int[] convertedBiomePalette;
            ByteArrayBinaryTag blockLightTag;
            ByteArrayBinaryTag skyLightTag;
            CompoundBinaryTag sectionData = (CompoundBinaryTag)sectionTag;
            int sectionY = sectionData.getInt("Y", Integer.MIN_VALUE);
            Check.stateCondition(sectionY == Integer.MIN_VALUE, "Missing section Y value");
            int yOffset = 16 * sectionY;
            if (sectionY < chunk.getMinSection() || sectionY >= chunk.getMaxSection()) continue;
            Section section = chunk.getSection(sectionY);
            BinaryTag binaryTag = sectionData.get("SkyLight");
            if (binaryTag instanceof ByteArrayBinaryTag && (skyLightTag = (ByteArrayBinaryTag)binaryTag).size() == 2048) {
                section.setSkyLight(skyLightTag.value());
            }
            if ((binaryTag = sectionData.get("BlockLight")) instanceof ByteArrayBinaryTag && (blockLightTag = (ByteArrayBinaryTag)binaryTag).size() == 2048) {
                section.setBlockLight(blockLightTag.value());
            }
            if ((convertedBiomePalette = this.loadBiomePalette(biomePaletteTag = (biomesTag = sectionData.getCompound("biomes")).getList("palette", BinaryTagTypes.STRING))).length == 1) {
                section.biomePalette().fill(convertedBiomePalette[0]);
            } else if (convertedBiomePalette.length > 1) {
                long[] packedIndices = biomesTag.getLongArray("data");
                Check.stateCondition(packedIndices.length == 0, "Missing packed biomes data");
                int[] biomeIndices = new int[64];
                int bitsPerEntry = packedIndices.length * 64 / biomeIndices.length;
                if (bitsPerEntry > 3) {
                    bitsPerEntry = MathUtils.bitsToRepresent(convertedBiomePalette.length);
                }
                Palettes.unpack(biomeIndices, packedIndices, bitsPerEntry);
                section.biomePalette().setAll((x, y, z) -> {
                    int index = x + z * 4 + y * 16;
                    return convertedBiomePalette[biomeIndices[index]];
                });
            }
            CompoundBinaryTag blockStatesTag = sectionData.getCompound("block_states");
            ListBinaryTag blockPaletteTag = blockStatesTag.getList("palette", BinaryTagTypes.COMPOUND);
            Block[] convertedPalette = this.loadBlockPalette(blockPaletteTag);
            if (blockPaletteTag.size() == 1) {
                section.blockPalette().fill(convertedPalette[0].stateId());
                continue;
            }
            if (blockPaletteTag.size() <= 1) continue;
            long[] packedStates = blockStatesTag.getLongArray("data");
            Check.stateCondition(packedStates.length == 0, "Missing packed states data");
            int[] blockStateIndices = new int[4096];
            Palettes.unpack(blockStateIndices, packedStates, packedStates.length * 64 / blockStateIndices.length);
            for (int y2 = 0; y2 < 16; ++y2) {
                for (int z2 = 0; z2 < 16; ++z2) {
                    for (int x2 = 0; x2 < 16; ++x2) {
                        try {
                            int blockIndex = y2 * 16 * 16 + z2 * 16 + x2;
                            int paletteIndex = blockStateIndices[blockIndex];
                            Block block = convertedPalette[paletteIndex];
                            chunk.setBlock(x2, y2 + yOffset, z2, block);
                            continue;
                        }
                        catch (Exception e) {
                            MinecraftServer.getExceptionManager().handleException(e);
                        }
                    }
                }
            }
        }
    }

    private Block[] loadBlockPalette(@NotNull ListBinaryTag paletteTag) {
        Block[] convertedPalette = new Block[paletteTag.size()];
        for (int i = 0; i < convertedPalette.length; ++i) {
            BlockHandler handler;
            CompoundBinaryTag paletteEntry = paletteTag.getCompound(i);
            String blockName = paletteEntry.getString("Name");
            if (blockName.equals("minecraft:air")) {
                convertedPalette[i] = Block.AIR;
                continue;
            }
            Block block = Objects.requireNonNull(Block.fromKey(blockName), "Unknown block " + blockName);
            HashMap<String, String> properties = new HashMap<String, String>();
            CompoundBinaryTag propertiesNBT = paletteEntry.getCompound("Properties");
            for (Map.Entry property : propertiesNBT) {
                Object v = property.getValue();
                if (v instanceof StringBinaryTag) {
                    StringBinaryTag propertyValue = (StringBinaryTag)v;
                    properties.put((String)property.getKey(), propertyValue.value());
                    continue;
                }
                LOGGER.warn("Fail to parse block state properties {}, expected a string for {}, but contents were {}", new Object[]{propertiesNBT, property.getKey(), TagStringIOExt.writeTag((BinaryTag)property.getValue())});
            }
            if (!properties.isEmpty()) {
                block = block.withProperties(properties);
            }
            if ((handler = MinecraftServer.getBlockManager().getHandler(block.name())) != null) {
                block = block.withHandler(handler);
            }
            convertedPalette[i] = block;
        }
        return convertedPalette;
    }

    private int[] loadBiomePalette(@NotNull ListBinaryTag paletteTag) {
        int[] convertedPalette = new int[paletteTag.size()];
        for (int i = 0; i < convertedPalette.length; ++i) {
            String name = paletteTag.getString(i);
            int biomeId = BIOME_REGISTRY.getId(Key.key((String)name));
            if (biomeId == -1) {
                biomeId = PLAINS_ID;
            }
            convertedPalette[i] = biomeId;
        }
        return convertedPalette;
    }

    private void loadBlockEntities(@NotNull Chunk loadedChunk, @NotNull CompoundBinaryTag chunkData) {
        for (BinaryTag blockEntityTag : chunkData.getList("block_entities", BinaryTagTypes.COMPOUND)) {
            CompoundBinaryTag trimmedTag;
            CompoundBinaryTag blockEntity = (CompoundBinaryTag)blockEntityTag;
            int x = blockEntity.getInt("x");
            int y = blockEntity.getInt("y");
            int z = blockEntity.getInt("z");
            Block block = loadedChunk.getBlock(x, y, z);
            BinaryTag binaryTag = blockEntity.get("id");
            if (binaryTag instanceof StringBinaryTag) {
                StringBinaryTag blockEntityId = (StringBinaryTag)binaryTag;
                BlockHandler handler = MinecraftServer.getBlockManager().getHandlerOrDummy(blockEntityId.value());
                block = block.withHandler(handler);
            }
            Block finalBlock = (trimmedTag = ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(blockEntity)).remove("id")).remove("keepPacked")).remove("x")).remove("y")).remove("z")).build()).size() > 0 ? block.withNbt(trimmedTag) : block;
            loadedChunk.setBlock(x, y, z, finalBlock);
        }
    }

    @Override
    public void saveInstance(@NotNull Instance instance) {
        CompoundBinaryTag nbt = instance.tagHandler().asCompound();
        if (nbt.size() == 0) {
            return;
        }
        try (OutputStream os = Files.newOutputStream(this.levelPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            BinaryTagIO.writer().writeNamed(Map.entry("", nbt), os, BinaryTagIO.Compression.GZIP);
        }
        catch (IOException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveChunk(@NotNull Chunk chunk) {
        RegionFile mcaFile;
        int chunkZ;
        int chunkX;
        block8: {
            chunkX = chunk.getChunkX();
            chunkZ = chunk.getChunkZ();
            this.fileCreationLock.lock();
            try {
                mcaFile = this.getMCAFile(chunkX, chunkZ);
                if (mcaFile != null) break block8;
                int regionX = CoordConversion.chunkToRegion(chunkX);
                int regionZ = CoordConversion.chunkToRegion(chunkZ);
                String regionFileName = RegionFile.getFileName(regionX, regionZ);
                try {
                    Path regionFile = this.regionPath.resolve(regionFileName);
                    if (!Files.exists(regionFile, new LinkOption[0])) {
                        Files.createDirectories(regionFile.getParent(), new FileAttribute[0]);
                        Files.createFile(regionFile, new FileAttribute[0]);
                    }
                    mcaFile = new RegionFile(regionFile);
                    this.alreadyLoaded.put(regionFileName, mcaFile);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to create region file for " + chunkX + ", " + chunkZ, (Throwable)e);
                    MinecraftServer.getExceptionManager().handleException(e);
                    this.fileCreationLock.unlock();
                    return;
                }
            }
            finally {
                this.fileCreationLock.unlock();
            }
        }
        try {
            CompoundBinaryTag.Builder chunkData = CompoundBinaryTag.builder();
            chunkData.putInt("DataVersion", 4189);
            chunkData.putInt("xPos", chunkX);
            chunkData.putInt("zPos", chunkZ);
            chunkData.putInt("yPos", chunk.getMinSection());
            chunkData.putString("status", "minecraft:full");
            chunkData.putLong("LastUpdate", chunk.getInstance().getWorldAge());
            this.saveSectionData(chunk, chunkData);
            mcaFile.writeChunkData(chunkX, chunkZ, chunkData.build());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save chunk " + chunkX + ", " + chunkZ, (Throwable)e);
            MinecraftServer.getExceptionManager().handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSectionData(@NotNull Chunk chunk, @NotNull CompoundBinaryTag.Builder chunkData) {
        ListBinaryTag.Builder sections = ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.COMPOUND);
        ListBinaryTag.Builder blockEntities = ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.COMPOUND);
        ArrayList<StringBinaryTag> biomePalette = new ArrayList<StringBinaryTag>();
        int[] biomeIndices = new int[64];
        ArrayList<CompoundBinaryTag> blockPaletteEntries = new ArrayList<CompoundBinaryTag>();
        IntArrayList blockPaletteIndices = new IntArrayList();
        int[] blockIndices = new int[4096];
        Chunk chunk2 = chunk;
        synchronized (chunk2) {
            for (int sectionY = chunk.getMinSection(); sectionY < chunk.getMaxSection(); ++sectionY) {
                byte[] blockLight;
                Section section = chunk.getSection(sectionY);
                CompoundBinaryTag.Builder sectionData = CompoundBinaryTag.builder();
                sectionData.putByte("Y", (byte)sectionY);
                byte[] skyLight = section.skyLight().array();
                if (skyLight != null && skyLight.length > 0) {
                    sectionData.putByteArray("SkyLight", skyLight);
                }
                if ((blockLight = section.blockLight().array()) != null && blockLight.length > 0) {
                    sectionData.putByteArray("BlockLight", blockLight);
                }
                for (int sectionLocalY = 0; sectionLocalY < 16; ++sectionLocalY) {
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            int y = sectionLocalY + sectionY * 16;
                            int blockIndex = x + sectionLocalY * 16 * 16 + z * 16;
                            Block block = chunk.getBlock(x, y, z);
                            int blockStateId = block.stateId();
                            CompoundBinaryTag blockState = this.getBlockState(block);
                            int blockPaletteIndex = blockPaletteIndices.indexOf(blockStateId);
                            if (blockPaletteIndex == -1) {
                                blockPaletteIndex = blockPaletteEntries.size();
                                blockPaletteEntries.add(blockState);
                                blockPaletteIndices.add(blockStateId);
                            }
                            blockIndices[blockIndex] = blockPaletteIndex;
                            if (x % 4 == 0 && sectionLocalY % 4 == 0 && z % 4 == 0) {
                                int biomeIndex = x / 4 + sectionLocalY / 4 * 4 * 4 + z / 4 * 4;
                                DynamicRegistry.Key<Biome> biomeKey = chunk.getBiome(x, y, z);
                                StringBinaryTag biomeName = StringBinaryTag.stringBinaryTag((String)biomeKey.name());
                                int biomePaletteIndex = biomePalette.indexOf(biomeName);
                                if (biomePaletteIndex == -1) {
                                    biomePaletteIndex = biomePalette.size();
                                    biomePalette.add(biomeName);
                                }
                                biomeIndices[biomeIndex] = biomePaletteIndex;
                            }
                            BlockHandler handler = block.handler();
                            CompoundBinaryTag originalNBT = block.nbt();
                            if (originalNBT == null && handler == null) continue;
                            CompoundBinaryTag.Builder blockEntityTag = CompoundBinaryTag.builder();
                            if (originalNBT != null) {
                                blockEntityTag.put(originalNBT);
                            }
                            if (handler != null) {
                                blockEntityTag.putString("id", handler.getKey().asString());
                            }
                            blockEntityTag.putInt("x", x + 16 * chunk.getChunkX());
                            blockEntityTag.putInt("y", y);
                            blockEntityTag.putInt("z", z + 16 * chunk.getChunkZ());
                            blockEntityTag.putByte("keepPacked", (byte)0);
                            blockEntities.add((BinaryTag)blockEntityTag.build());
                        }
                    }
                }
                CompoundBinaryTag.Builder blockStates = CompoundBinaryTag.builder();
                blockStates.put("palette", (BinaryTag)ListBinaryTag.listBinaryTag((BinaryTagType)BinaryTagTypes.COMPOUND, blockPaletteEntries));
                if (blockPaletteEntries.size() > 1) {
                    int bitsPerEntry = (int)Math.max(4.0, Math.ceil(Math.log(blockPaletteEntries.size()) / Math.log(2.0)));
                    blockStates.putLongArray("data", Palettes.pack(blockIndices, bitsPerEntry));
                }
                sectionData.put("block_states", (BinaryTag)blockStates.build());
                CompoundBinaryTag.Builder biomes = CompoundBinaryTag.builder();
                biomes.put("palette", (BinaryTag)ListBinaryTag.listBinaryTag((BinaryTagType)BinaryTagTypes.STRING, biomePalette));
                if (biomePalette.size() > 1) {
                    int bitsPerEntry = (int)Math.max(1.0, Math.ceil(Math.log(biomePalette.size()) / Math.log(2.0)));
                    biomes.putLongArray("data", Palettes.pack(biomeIndices, bitsPerEntry));
                }
                sectionData.put("biomes", (BinaryTag)biomes.build());
                biomePalette.clear();
                blockPaletteEntries.clear();
                blockPaletteIndices.clear();
                sections.add((BinaryTag)sectionData.build());
            }
        }
        chunkData.put("sections", (BinaryTag)sections.build());
        chunkData.put("block_entities", (BinaryTag)blockEntities.build());
    }

    private CompoundBinaryTag getBlockState(Block block) {
        return (CompoundBinaryTag)this.blockStateId2ObjectCacheTLS.get().computeIfAbsent(block.stateId(), _unused -> {
            CompoundBinaryTag.Builder tag = CompoundBinaryTag.builder();
            tag.putString("Name", block.name());
            if (!block.properties().isEmpty()) {
                Map<String, String> defaultProperties = Block.fromBlockId(block.id()).properties();
                CompoundBinaryTag.Builder propertiesTag = CompoundBinaryTag.builder();
                for (Map.Entry<String, String> entry : block.properties().entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (defaultProperties.get(key).equals(value)) continue;
                    propertiesTag.putString(key, value);
                }
                CompoundBinaryTag properties = propertiesTag.build();
                if (properties.size() > 0) {
                    tag.put("Properties", (BinaryTag)properties);
                }
            }
            return tag.build();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadChunk(Chunk chunk) {
        int regionX = CoordConversion.chunkToRegion(chunk.getChunkX());
        int regionZ = CoordConversion.chunkToRegion(chunk.getChunkZ());
        IntIntImmutablePair regionKey = new IntIntImmutablePair(regionX, regionZ);
        this.perRegionLoadedChunksLock.lock();
        try {
            Set chunks = (Set)this.perRegionLoadedChunks.get(regionKey);
            if (chunks != null) {
                chunks.remove(new IntIntImmutablePair(chunk.getChunkX(), chunk.getChunkZ()));
                if (chunks.isEmpty()) {
                    this.perRegionLoadedChunks.remove(regionKey);
                    RegionFile regionFile = this.alreadyLoaded.remove(RegionFile.getFileName(regionX, regionZ));
                    if (regionFile != null) {
                        try {
                            regionFile.close();
                        }
                        catch (IOException e) {
                            MinecraftServer.getExceptionManager().handleException(e);
                        }
                    }
                }
            }
        }
        finally {
            this.perRegionLoadedChunksLock.unlock();
        }
    }

    @Override
    public boolean supportsParallelLoading() {
        return true;
    }

    @Override
    public boolean supportsParallelSaving() {
        return true;
    }

    private static class RegionCache
    extends ConcurrentHashMap<IntIntImmutablePair, Set<IntIntImmutablePair>> {
        private RegionCache() {
        }
    }
}

