/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.game;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import net.kyori.adventure.key.Key;
import net.minestom.server.game.GameEvent;
import net.minestom.server.registry.Registry;
import org.jetbrains.annotations.NotNull;

final class GameEventImpl
extends Record
implements GameEvent {
    private final Registry.GameEventEntry registry;
    private final Key key;
    private final int id;
    private static final Registry.Container<GameEvent> CONTAINER = Registry.createStaticContainer(Registry.Resource.GAME_EVENTS, GameEventImpl::createImpl);

    private GameEventImpl(Registry.GameEventEntry registry) {
        this(registry, registry.key(), registry.main().getInt("id"));
    }

    GameEventImpl(Registry.GameEventEntry registry, Key key, int id) {
        this.registry = registry;
        this.key = key;
        this.id = id;
    }

    private static GameEventImpl createImpl(String namespace, Registry.Properties properties) {
        return new GameEventImpl(Registry.gameEventEntry(namespace, properties));
    }

    static Collection<GameEvent> values() {
        return CONTAINER.values();
    }

    public static GameEvent get(@NotNull String namespace) {
        return CONTAINER.get(namespace);
    }

    static GameEvent getSafe(@NotNull String namespace) {
        return CONTAINER.getSafe(namespace);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{GameEventImpl.class, "registry;key;id", "registry", "key", "id"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GameEventImpl.class, "registry;key;id", "registry", "key", "id"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GameEventImpl.class, "registry;key;id", "registry", "key", "id"}, this, o);
    }

    @Override
    public Registry.GameEventEntry registry() {
        return this.registry;
    }

    @Override
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.id;
    }
}

