/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.animal.AbstractHorseMeta;
import org.jetbrains.annotations.NotNull;

public class HorseMeta
extends AbstractHorseMeta {
    public HorseMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public Variant getVariant() {
        return HorseMeta.getVariantFromID(this.metadata.get(MetadataDef.Horse.VARIANT));
    }

    public void setVariant(Variant variant) {
        this.metadata.set(MetadataDef.Horse.VARIANT, HorseMeta.getVariantID(variant.marking, variant.color));
    }

    public static int getVariantID(@NotNull Marking marking, @NotNull Color color) {
        return (marking.ordinal() << 8) + color.ordinal();
    }

    public static Variant getVariantFromID(int variantID) {
        return new Variant(Marking.VALUES[variantID >> 8], Color.VALUES[variantID & 0xFF]);
    }

    public static class Variant {
        private Marking marking;
        private Color color;

        public Variant(@NotNull Marking marking, @NotNull Color color) {
            this.marking = marking;
            this.color = color;
        }

        @NotNull
        public Marking getMarking() {
            return this.marking;
        }

        public void setMarking(@NotNull Marking marking) {
            this.marking = marking;
        }

        @NotNull
        public Color getColor() {
            return this.color;
        }

        public void setColor(@NotNull Color color) {
            this.color = color;
        }
    }

    public static enum Marking {
        NONE,
        WHITE,
        WHITE_FIELD,
        WHITE_DOTS,
        BLACK_DOTS;

        private static final Marking[] VALUES;

        static {
            VALUES = Marking.values();
        }
    }

    public static enum Color {
        WHITE,
        CREAMY,
        CHESTNUT,
        BROWN,
        BLACK,
        GRAY,
        DARK_BROWN;

        private static final Color[] VALUES;

        static {
            VALUES = Color.values();
        }
    }
}

