/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.attribute;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.entity.attribute.AttributeOperation;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record AttributeModifier(@NotNull Key id, double amount, @NotNull AttributeOperation operation) {
    public static final NetworkBuffer.Type<AttributeModifier> NETWORK_TYPE = new NetworkBuffer.Type<AttributeModifier>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, AttributeModifier value) {
            buffer.write(NetworkBuffer.STRING, value.id.asString());
            buffer.write(NetworkBuffer.DOUBLE, value.amount);
            buffer.write(AttributeOperation.NETWORK_TYPE, value.operation);
        }

        @Override
        public AttributeModifier read(@NotNull NetworkBuffer buffer) {
            return new AttributeModifier(Key.key((String)buffer.read(NetworkBuffer.STRING)), (double)buffer.read(NetworkBuffer.DOUBLE), buffer.read(AttributeOperation.NETWORK_TYPE));
        }
    };
    public static final BinaryTagSerializer<AttributeModifier> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> new AttributeModifier(Key.key((String)tag.getString("id")), tag.getDouble("amount"), AttributeOperation.NBT_TYPE.read(tag.get("operation"))), value -> ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("id", value.id.asString())).putDouble("amount", value.amount)).put("operation", AttributeOperation.NBT_TYPE.write(value.operation))).build());

    public AttributeModifier(@NotNull String id, double amount, @NotNull AttributeOperation operation) {
        this(Key.key((String)id), amount, operation);
    }
}

