/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.Collection;
import net.kyori.adventure.key.Key;
import net.minestom.server.entity.EntityTypeImpl;
import net.minestom.server.entity.EntityTypes;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface EntityType
extends StaticProtocolObject,
EntityTypes
permits EntityTypeImpl {
    public static final NetworkBuffer.Type<EntityType> NETWORK_TYPE = NetworkBuffer.VAR_INT.transform(EntityType::fromId, EntityType::id);
    public static final BinaryTagSerializer<EntityType> NBT_TYPE = BinaryTagSerializer.INT.map(EntityType::fromId, EntityType::id);

    @Override
    @Contract(pure=true)
    @NotNull
    public Registry.EntityEntry registry();

    @Override
    @NotNull
    default public Key key() {
        return this.registry().key();
    }

    @Override
    default public int id() {
        return this.registry().id();
    }

    default public double width() {
        return this.registry().width();
    }

    default public double height() {
        return this.registry().height();
    }

    @NotNull
    public static @NotNull Collection<@NotNull EntityType> values() {
        return EntityTypeImpl.values();
    }

    public static EntityType fromKey(@NotNull String key) {
        return EntityTypeImpl.getSafe(key);
    }

    public static EntityType fromKey(@NotNull Key key) {
        return EntityType.fromKey(key.asString());
    }

    @Nullable
    public static EntityType fromId(int id) {
        return EntityTypeImpl.getId(id);
    }
}

