/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.ServerProcess;
import net.minestom.server.advancements.AdvancementManager;
import net.minestom.server.adventure.bossbar.BossBarManager;
import net.minestom.server.command.CommandManager;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.metadata.animal.tameable.WolfMeta;
import net.minestom.server.entity.metadata.other.PaintingMeta;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.GlobalEventHandler;
import net.minestom.server.event.server.ServerTickMonitorEvent;
import net.minestom.server.exception.ExceptionManager;
import net.minestom.server.gamedata.tags.TagManager;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceManager;
import net.minestom.server.instance.block.BlockManager;
import net.minestom.server.instance.block.banner.BannerPattern;
import net.minestom.server.instance.block.jukebox.JukeboxSong;
import net.minestom.server.item.armor.TrimMaterial;
import net.minestom.server.item.armor.TrimPattern;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.item.enchant.EntityEffect;
import net.minestom.server.item.enchant.LevelBasedValue;
import net.minestom.server.item.enchant.LocationEffect;
import net.minestom.server.item.enchant.ValueEffect;
import net.minestom.server.item.instrument.Instrument;
import net.minestom.server.listener.manager.PacketListenerManager;
import net.minestom.server.message.ChatType;
import net.minestom.server.monitoring.BenchmarkManager;
import net.minestom.server.monitoring.TickMonitor;
import net.minestom.server.network.ConnectionManager;
import net.minestom.server.network.packet.PacketParser;
import net.minestom.server.network.packet.PacketVanilla;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.network.socket.Server;
import net.minestom.server.recipe.RecipeManager;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.scoreboard.TeamManager;
import net.minestom.server.snapshot.EntitySnapshot;
import net.minestom.server.snapshot.ServerSnapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.thread.Acquirable;
import net.minestom.server.thread.ThreadDispatcher;
import net.minestom.server.thread.ThreadProvider;
import net.minestom.server.timer.SchedulerManager;
import net.minestom.server.utils.PacketViewableUtils;
import net.minestom.server.utils.collection.MappedCollection;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.world.DimensionType;
import net.minestom.server.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerProcessImpl
implements ServerProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerProcessImpl.class);
    private final ExceptionManager exception;
    private final DynamicRegistry<BinaryTagSerializer<? extends LevelBasedValue>> enchantmentLevelBasedValues;
    private final DynamicRegistry<BinaryTagSerializer<? extends ValueEffect>> enchantmentValueEffects;
    private final DynamicRegistry<BinaryTagSerializer<? extends EntityEffect>> enchantmentEntityEffects;
    private final DynamicRegistry<BinaryTagSerializer<? extends LocationEffect>> enchantmentLocationEffects;
    private final DynamicRegistry<ChatType> chatType;
    private final DynamicRegistry<DimensionType> dimensionType;
    private final DynamicRegistry<Biome> biome;
    private final DynamicRegistry<DamageType> damageType;
    private final DynamicRegistry<TrimMaterial> trimMaterial;
    private final DynamicRegistry<TrimPattern> trimPattern;
    private final DynamicRegistry<BannerPattern> bannerPattern;
    private final DynamicRegistry<WolfMeta.Variant> wolfVariant;
    private final DynamicRegistry<Enchantment> enchantment;
    private final DynamicRegistry<PaintingMeta.Variant> paintingVariant;
    private final DynamicRegistry<JukeboxSong> jukeboxSong;
    private final DynamicRegistry<Instrument> instrument;
    private final ConnectionManager connection;
    private final PacketListenerManager packetListener;
    private final PacketParser<ClientPacket> packetParser;
    private final InstanceManager instance;
    private final BlockManager block;
    private final CommandManager command;
    private final RecipeManager recipe;
    private final TeamManager team;
    private final GlobalEventHandler eventHandler;
    private final SchedulerManager scheduler;
    private final BenchmarkManager benchmark;
    private final AdvancementManager advancement;
    private final BossBarManager bossBar;
    private final TagManager tag;
    private final Server server;
    private final ThreadDispatcher<Chunk> dispatcher;
    private final ServerProcess.Ticker ticker;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();

    public ServerProcessImpl() {
        this.exception = new ExceptionManager();
        this.enchantmentLevelBasedValues = LevelBasedValue.createDefaultRegistry();
        this.enchantmentValueEffects = ValueEffect.createDefaultRegistry();
        this.enchantmentEntityEffects = EntityEffect.createDefaultRegistry();
        this.enchantmentLocationEffects = LocationEffect.createDefaultRegistry();
        this.chatType = ChatType.createDefaultRegistry();
        this.dimensionType = DimensionType.createDefaultRegistry();
        this.biome = Biome.createDefaultRegistry();
        this.damageType = DamageType.createDefaultRegistry();
        this.trimMaterial = TrimMaterial.createDefaultRegistry();
        this.trimPattern = TrimPattern.createDefaultRegistry();
        this.bannerPattern = BannerPattern.createDefaultRegistry();
        this.wolfVariant = WolfMeta.Variant.createDefaultRegistry();
        this.enchantment = Enchantment.createDefaultRegistry(this);
        this.paintingVariant = PaintingMeta.Variant.createDefaultRegistry();
        this.jukeboxSong = JukeboxSong.createDefaultRegistry();
        this.instrument = Instrument.createDefaultRegistry();
        this.connection = new ConnectionManager();
        this.packetListener = new PacketListenerManager();
        this.packetParser = PacketVanilla.CLIENT_PACKET_PARSER;
        this.instance = new InstanceManager(this);
        this.block = new BlockManager();
        this.command = new CommandManager();
        this.recipe = new RecipeManager();
        this.team = new TeamManager();
        this.eventHandler = new GlobalEventHandler();
        this.scheduler = new SchedulerManager();
        this.benchmark = new BenchmarkManager();
        this.advancement = new AdvancementManager();
        this.bossBar = new BossBarManager();
        this.tag = new TagManager();
        this.server = new Server(this.packetParser);
        this.dispatcher = ThreadDispatcher.of(ThreadProvider.counter(), ServerFlag.DISPATCHER_THREADS);
        this.ticker = new TickerImpl();
    }

    @Override
    @NotNull
    public ExceptionManager exception() {
        return this.exception;
    }

    @Override
    @NotNull
    public DynamicRegistry<DamageType> damageType() {
        return this.damageType;
    }

    @Override
    @NotNull
    public DynamicRegistry<TrimMaterial> trimMaterial() {
        return this.trimMaterial;
    }

    @Override
    @NotNull
    public DynamicRegistry<TrimPattern> trimPattern() {
        return this.trimPattern;
    }

    @Override
    @NotNull
    public DynamicRegistry<BannerPattern> bannerPattern() {
        return this.bannerPattern;
    }

    @Override
    @NotNull
    public DynamicRegistry<WolfMeta.Variant> wolfVariant() {
        return this.wolfVariant;
    }

    @Override
    @NotNull
    public DynamicRegistry<Enchantment> enchantment() {
        return this.enchantment;
    }

    @Override
    @NotNull
    public DynamicRegistry<PaintingMeta.Variant> paintingVariant() {
        return this.paintingVariant;
    }

    @Override
    @NotNull
    public DynamicRegistry<JukeboxSong> jukeboxSong() {
        return this.jukeboxSong;
    }

    @Override
    @NotNull
    public DynamicRegistry<Instrument> instrument() {
        return this.instrument;
    }

    @Override
    @NotNull
    public DynamicRegistry<BinaryTagSerializer<? extends LevelBasedValue>> enchantmentLevelBasedValues() {
        return this.enchantmentLevelBasedValues;
    }

    @Override
    @NotNull
    public DynamicRegistry<BinaryTagSerializer<? extends ValueEffect>> enchantmentValueEffects() {
        return this.enchantmentValueEffects;
    }

    @Override
    @NotNull
    public DynamicRegistry<BinaryTagSerializer<? extends EntityEffect>> enchantmentEntityEffects() {
        return this.enchantmentEntityEffects;
    }

    @Override
    @NotNull
    public DynamicRegistry<BinaryTagSerializer<? extends LocationEffect>> enchantmentLocationEffects() {
        return this.enchantmentLocationEffects;
    }

    @Override
    @NotNull
    public ConnectionManager connection() {
        return this.connection;
    }

    @Override
    @NotNull
    public InstanceManager instance() {
        return this.instance;
    }

    @Override
    @NotNull
    public BlockManager block() {
        return this.block;
    }

    @Override
    @NotNull
    public CommandManager command() {
        return this.command;
    }

    @Override
    @NotNull
    public RecipeManager recipe() {
        return this.recipe;
    }

    @Override
    @NotNull
    public TeamManager team() {
        return this.team;
    }

    @Override
    @NotNull
    public GlobalEventHandler eventHandler() {
        return this.eventHandler;
    }

    @Override
    @NotNull
    public SchedulerManager scheduler() {
        return this.scheduler;
    }

    @Override
    @NotNull
    public BenchmarkManager benchmark() {
        return this.benchmark;
    }

    @Override
    @NotNull
    public AdvancementManager advancement() {
        return this.advancement;
    }

    @Override
    @NotNull
    public BossBarManager bossBar() {
        return this.bossBar;
    }

    @Override
    @NotNull
    public TagManager tag() {
        return this.tag;
    }

    @Override
    @NotNull
    public DynamicRegistry<ChatType> chatType() {
        return this.chatType;
    }

    @Override
    @NotNull
    public DynamicRegistry<DimensionType> dimensionType() {
        return this.dimensionType;
    }

    @Override
    @NotNull
    public DynamicRegistry<Biome> biome() {
        return this.biome;
    }

    @Override
    @NotNull
    public PacketListenerManager packetListener() {
        return this.packetListener;
    }

    @Override
    @NotNull
    public PacketParser<ClientPacket> packetParser() {
        return this.packetParser;
    }

    @Override
    @NotNull
    public Server server() {
        return this.server;
    }

    @Override
    @NotNull
    public ThreadDispatcher<Chunk> dispatcher() {
        return this.dispatcher;
    }

    @Override
    @NotNull
    public ServerProcess.Ticker ticker() {
        return this.ticker;
    }

    @Override
    public void start(@NotNull SocketAddress socketAddress) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Server already started");
        }
        LOGGER.info("Starting " + MinecraftServer.getBrandName() + " server.");
        try {
            this.server.init(socketAddress);
        }
        catch (IOException e) {
            this.exception.handleException(e);
            throw new RuntimeException(e);
        }
        this.server.start();
        LOGGER.info(MinecraftServer.getBrandName() + " server started successfully.");
        if (ServerFlag.SHUTDOWN_ON_SIGNAL) {
            Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        }
    }

    @Override
    public void stop() {
        if (!this.stopped.compareAndSet(false, true)) {
            return;
        }
        LOGGER.info("Stopping " + MinecraftServer.getBrandName() + " server.");
        this.scheduler.shutdown();
        this.connection.shutdown();
        this.server.stop();
        LOGGER.info("Shutting down all thread pools.");
        this.benchmark.disable();
        this.dispatcher.shutdown();
        LOGGER.info(MinecraftServer.getBrandName() + " server stopped successfully.");
    }

    @Override
    public boolean isAlive() {
        return this.started.get() && !this.stopped.get();
    }

    @Override
    @NotNull
    public ServerSnapshot updateSnapshot(@NotNull SnapshotUpdater updater) {
        ArrayList instanceRefs = new ArrayList();
        Int2ObjectOpenHashMap entityRefs = new Int2ObjectOpenHashMap();
        for (Instance instance : this.instance.getInstances()) {
            instanceRefs.add(updater.reference(instance));
            for (Entity entity : instance.getEntities()) {
                entityRefs.put(entity.getEntityId(), updater.reference(entity));
            }
        }
        return new SnapshotImpl.Server(MappedCollection.plainReferences(instanceRefs), (Int2ObjectOpenHashMap<AtomicReference<EntitySnapshot>>)entityRefs);
    }

    private final class TickerImpl
    implements ServerProcess.Ticker {
        private TickerImpl() {
        }

        @Override
        public void tick(long nanoTime) {
            long msTime = System.currentTimeMillis();
            ServerProcessImpl.this.scheduler().processTick();
            ServerProcessImpl.this.connection().tick(msTime);
            this.serverTick(msTime);
            ServerProcessImpl.this.scheduler().processTickEnd();
            PacketViewableUtils.flush();
            double acquisitionTimeMs = (double)Acquirable.resetAcquiringTime() / 1000000.0;
            double tickTimeMs = (double)(System.nanoTime() - nanoTime) / 1000000.0;
            TickMonitor tickMonitor = new TickMonitor(tickTimeMs, acquisitionTimeMs);
            EventDispatcher.call(new ServerTickMonitorEvent(tickMonitor));
        }

        private void serverTick(long tickStart) {
            for (Instance instance : ServerProcessImpl.this.instance().getInstances()) {
                try {
                    instance.tick(tickStart);
                }
                catch (Exception e) {
                    ServerProcessImpl.this.exception().handleException(e);
                }
            }
            ServerProcessImpl.this.dispatcher().updateAndAwait(tickStart);
            long tickTime = System.currentTimeMillis() - tickStart;
            ServerProcessImpl.this.dispatcher().refreshThreads(tickTime);
        }
    }
}

