/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerFlag {
    public static final boolean SHUTDOWN_ON_SIGNAL = ServerFlag.booleanProperty("minestom.shutdown-on-signal", true);
    public static final int SERVER_TICKS_PER_SECOND = ServerFlag.intProperty("minestom.tps", 20);
    public static final int SERVER_MAX_TICK_CATCH_UP = ServerFlag.intProperty("minestom.max-tick-catch-up", 5);
    public static final int CHUNK_VIEW_DISTANCE = ServerFlag.intProperty("minestom.chunk-view-distance", 8);
    public static final int ENTITY_VIEW_DISTANCE = ServerFlag.intProperty("minestom.entity-view-distance", 5);
    public static final int ENTITY_SYNCHRONIZATION_TICKS = ServerFlag.intProperty("minestom.entity-synchronization-ticks", 20);
    public static final int DISPATCHER_THREADS = ServerFlag.intProperty("minestom.dispatcher-threads", 1);
    public static final int SEND_LIGHT_AFTER_BLOCK_PLACEMENT_DELAY = ServerFlag.intProperty("minestom.send-light-after-block-placement-delay", 100);
    public static final long LOGIN_PLUGIN_MESSAGE_TIMEOUT = ServerFlag.longProperty("minestom.login-plugin-message-timeout", 5000L);
    public static final long KNOWN_PACKS_RESPONSE_TIMEOUT = ServerFlag.longProperty("minestom.known-packs-response-timeout", 300000L);
    public static final int PLAYER_PACKET_PER_TICK = ServerFlag.intProperty("minestom.packet-per-tick", 50);
    public static final int PLAYER_PACKET_QUEUE_SIZE = ServerFlag.intProperty("minestom.packet-queue-size", 1000);
    public static final long KEEP_ALIVE_DELAY = ServerFlag.longProperty("minestom.keep-alive-delay", 10000L);
    public static final long KEEP_ALIVE_KICK = ServerFlag.longProperty("minestom.keep-alive-kick", 15000L);
    public static final int PLAYER_CHUNK_UPDATE_LIMITER_HISTORY_SIZE = ServerFlag.intProperty("minestom.player.chunk-update-limiter-history-size", 5, 0, Integer.MAX_VALUE);
    public static final int MAX_PACKET_SIZE = ServerFlag.intProperty("minestom.max-packet-size", 0x1FFFFF);
    public static final int MAX_PACKET_SIZE_PRE_AUTH = ServerFlag.intProperty("minestom.max-packet-size-pre-auth", 8192);
    public static final int SOCKET_SEND_BUFFER_SIZE = ServerFlag.intProperty("minestom.send-buffer-size", 262143);
    public static final int SOCKET_RECEIVE_BUFFER_SIZE = ServerFlag.intProperty("minestom.receive-buffer-size", Short.MAX_VALUE);
    public static final boolean SOCKET_NO_DELAY = ServerFlag.booleanProperty("minestom.tcp-no-delay", true);
    public static final int SOCKET_TIMEOUT = ServerFlag.intProperty("minestom.socket-timeout", 15000);
    public static final int POOLED_BUFFER_SIZE = ServerFlag.intProperty("minestom.pooled-buffer-size", 16383);
    public static final float MIN_CHUNKS_PER_TICK = ServerFlag.floatProperty("minestom.chunk-queue.min-per-tick", 0.01f);
    public static final float MAX_CHUNKS_PER_TICK = ServerFlag.floatProperty("minestom.chunk-queue.max-per-tick", 64.0f);
    public static final float CHUNKS_PER_TICK_MULTIPLIER = ServerFlag.floatProperty("minestom.chunk-queue.multiplier", 1.0f);
    public static final boolean GROUPED_PACKET = ServerFlag.booleanProperty("minestom.grouped-packet", true);
    public static final boolean CACHED_PACKET = ServerFlag.booleanProperty("minestom.cached-packet", true);
    public static final boolean VIEWABLE_PACKET = ServerFlag.booleanProperty("minestom.viewable-packet", true);
    public static final boolean TAG_HANDLER_CACHE_ENABLED = ServerFlag.booleanProperty("minestom.tag-handler-cache", true);
    public static final boolean SERIALIZE_EMPTY_COMPOUND = ServerFlag.booleanProperty("minestom.serialization.serialize-empty-nbt-compound", false);
    @NotNull
    public static final String AUTH_URL = ServerFlag.stringProperty("minestom.auth.url", "https://sessionserver.mojang.com/session/minecraft/hasJoined");
    public static final boolean AUTH_PREVENT_PROXY_CONNECTIONS = ServerFlag.booleanProperty("minestom.auth.prevent-proxy-connections", false);
    public static final int WORLD_BORDER_SIZE = ServerFlag.intProperty("minestom.world-border-size", 29999984);
    @NotNull
    public static final String MAP_RGB_MAPPING = ServerFlag.stringProperty("minestom.map.rgbmapping", "lazy");
    public static final int MAP_RGB_REDUCTION = ServerFlag.intProperty("minestom.map.rgbreduction", -1);
    public static final boolean ENFORCE_INTERACTION_LIMIT = ServerFlag.booleanProperty("minestom.enforce-entity-interaction-range", true);
    public static final boolean REGISTRY_UNSAFE_OPS = ServerFlag.booleanProperty("minestom.registry.unsafe-ops");
    public static final boolean EVENT_NODE_ALLOW_MULTIPLE_PARENTS = ServerFlag.booleanProperty("minestom.event.multiple-parents");
    public static boolean INSIDE_TEST = ServerFlag.booleanProperty("minestom.inside-test", false);

    private ServerFlag() {
    }

    private static boolean booleanProperty(@NotNull String name) {
        return Boolean.getBoolean(name);
    }

    private static boolean booleanProperty(@NotNull String name, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String value = System.getProperty(name);
            if (value != null) {
                result = Boolean.parseBoolean(value);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return result;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    private static String stringProperty(@NotNull String name, @Nullable String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    private static String stringProperty(@NotNull String name) {
        return System.getProperty(name);
    }

    private static int intProperty(@NotNull String name, int defaultValue, int minValue, int maxValue) {
        int value = Integer.getInteger(name, defaultValue);
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException(String.format("Property '%s' value must be in range [%d..%d] but was %d", name, minValue, maxValue, value));
        }
        return value;
    }

    private static int intProperty(String name, int defaultValue) {
        return ServerFlag.intProperty(name, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static long longProperty(@NotNull String name, long defaultValue) {
        return Long.getLong(name, defaultValue);
    }

    private static float floatProperty(@NotNull String name, float defaultValue) {
        float result = defaultValue;
        try {
            String value = System.getProperty(name);
            if (value != null) {
                result = Float.parseFloat(value);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return result;
    }
}

