/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.minestom.server.item.book.FilteredText;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record WritableBookContent(@NotNull List<FilteredText<String>> pages) {
    public static final WritableBookContent EMPTY = new WritableBookContent(List.of());
    public static final NetworkBuffer.Type<WritableBookContent> NETWORK_TYPE = new NetworkBuffer.Type<WritableBookContent>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, WritableBookContent value) {
            buffer.writeCollection(FilteredText.STRING_NETWORK_TYPE, value.pages);
        }

        @Override
        public WritableBookContent read(@NotNull NetworkBuffer buffer) {
            return new WritableBookContent(buffer.readCollection(FilteredText.STRING_NETWORK_TYPE, 100));
        }
    };
    public static final BinaryTagSerializer<WritableBookContent> NBT_TYPE = new BinaryTagSerializer<WritableBookContent>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull WritableBookContent value) {
            ListBinaryTag.Builder pages = ListBinaryTag.builder();
            for (FilteredText<String> page : value.pages) {
                pages.add(FilteredText.STRING_NBT_TYPE.write(page));
            }
            return ((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("pages", (BinaryTag)pages.build())).build();
        }

        @Override
        @NotNull
        public WritableBookContent read(@NotNull BinaryTag tag) {
            if (!(tag instanceof CompoundBinaryTag)) {
                return EMPTY;
            }
            CompoundBinaryTag compound = (CompoundBinaryTag)tag;
            ListBinaryTag pagesTag = compound.getList("pages");
            if (pagesTag.size() == 0) {
                return EMPTY;
            }
            ArrayList<FilteredText<String>> pages = new ArrayList<FilteredText<String>>(pagesTag.size());
            for (BinaryTag pageTag : pagesTag) {
                pages.add(FilteredText.STRING_NBT_TYPE.read(pageTag));
            }
            return new WritableBookContent(pages);
        }
    };

    public WritableBookContent(@NotNull List<FilteredText<String>> pages) {
        pages = List.copyOf(pages);
    }
}

