/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.item.ItemStack;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface TransactionType {
    public static final TransactionType ADD = (inventory, itemStack, slotPredicate, start, end, step) -> {
        ItemStack inventoryItem;
        int i;
        Int2ObjectOpenHashMap itemChangesMap = new Int2ObjectOpenHashMap();
        for (i = start; i < end; i += step) {
            int maxSize;
            int itemAmount;
            inventoryItem = inventory.getItemStack(i);
            if (inventoryItem.isAir() || !itemStack.isSimilar(inventoryItem) || (itemAmount = inventoryItem.amount()) >= (maxSize = inventoryItem.maxStackSize()) || !slotPredicate.test(i, inventoryItem)) continue;
            int itemStackAmount = itemStack.amount();
            int totalAmount = itemStackAmount + itemAmount;
            if (!MathUtils.isBetween(totalAmount, 0, itemStack.maxStackSize())) {
                itemChangesMap.put(i, (Object)inventoryItem.withAmount(maxSize));
                itemStack = itemStack.withAmount(totalAmount - maxSize);
                continue;
            }
            itemChangesMap.put(i, (Object)inventoryItem.withAmount(totalAmount));
            itemStack = ItemStack.AIR;
            break;
        }
        for (i = start; i < end; i += step) {
            inventoryItem = inventory.getItemStack(i);
            if (!inventoryItem.isAir() || !slotPredicate.test(i, inventoryItem)) continue;
            itemChangesMap.put(i, (Object)itemStack);
            itemStack = ItemStack.AIR;
            break;
        }
        return Pair.of((Object)itemStack, (Object)itemChangesMap);
    };
    public static final TransactionType TAKE = (inventory, itemStack, slotPredicate, start, end, step) -> {
        Int2ObjectOpenHashMap itemChangesMap = new Int2ObjectOpenHashMap();
        for (int i = start; i < end; i += step) {
            ItemStack inventoryItem = inventory.getItemStack(i);
            if (inventoryItem.isAir() || !itemStack.isSimilar(inventoryItem) || !slotPredicate.test(i, inventoryItem)) continue;
            int itemAmount = inventoryItem.amount();
            int itemStackAmount = itemStack.amount();
            if (itemStackAmount < itemAmount) {
                itemChangesMap.put(i, (Object)inventoryItem.withAmount(itemAmount - itemStackAmount));
                itemStack = ItemStack.AIR;
                break;
            }
            itemChangesMap.put(i, (Object)ItemStack.AIR);
            itemStack = itemStack.withAmount(itemStackAmount - itemAmount);
            if (itemStack.amount() != 0) continue;
            itemStack = ItemStack.AIR;
            break;
        }
        return Pair.of((Object)itemStack, (Object)itemChangesMap);
    };

    @NotNull
    public Pair<ItemStack, Map<Integer, ItemStack>> process(@NotNull AbstractInventory var1, @NotNull ItemStack var2, @NotNull SlotPredicate var3, int var4, int var5, int var6);

    @NotNull
    default public Pair<ItemStack, Map<Integer, ItemStack>> process(@NotNull AbstractInventory inventory, @NotNull ItemStack itemStack, @NotNull SlotPredicate slotPredicate) {
        return this.process(inventory, itemStack, slotPredicate, 0, inventory.getInnerSize(), 1);
    }

    @NotNull
    default public Pair<ItemStack, Map<Integer, ItemStack>> process(@NotNull AbstractInventory inventory, @NotNull ItemStack itemStack) {
        return this.process(inventory, itemStack, (slot, itemStack1) -> true);
    }

    @FunctionalInterface
    public static interface SlotPredicate {
        public boolean test(int var1, @NotNull ItemStack var2);
    }
}

