/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.serializer.nbt;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minestom.server.adventure.serializer.nbt.NbtComponentSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

final class NbtComponentSerializerImpl
implements NbtComponentSerializer {
    static final NbtComponentSerializer INSTANCE = new NbtComponentSerializerImpl();

    NbtComponentSerializerImpl() {
    }

    @NotNull
    public Component deserialize(@NotNull BinaryTag input) {
        return this.deserializeAnyComponent(input);
    }

    @NotNull
    public BinaryTag serialize(@NotNull Component component) {
        return this.serializeComponent(component);
    }

    @NotNull
    private Component deserializeAnyComponent(@NotNull BinaryTag nbt) {
        BinaryTag binaryTag = nbt;
        Objects.requireNonNull(binaryTag);
        BinaryTag binaryTag2 = binaryTag;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CompoundBinaryTag.class, StringBinaryTag.class, ListBinaryTag.class}, (Object)binaryTag2, n)) {
            case 0 -> {
                CompoundBinaryTag compound = (CompoundBinaryTag)binaryTag2;
                yield this.deserializeComponent(compound);
            }
            case 1 -> {
                StringBinaryTag string = (StringBinaryTag)binaryTag2;
                yield Component.text((String)string.value());
            }
            case 2 -> {
                ListBinaryTag list = (ListBinaryTag)binaryTag2;
                TextComponent.Builder builder = Component.text();
                for (BinaryTag element : list) {
                    builder.append(this.deserializeAnyComponent(element));
                }
                yield (TextComponent)builder.build();
            }
            default -> throw new UnsupportedOperationException("Unknown NBT type: " + nbt.getClass().getName());
        };
    }

    @NotNull
    private Component deserializeComponent(@NotNull CompoundBinaryTag compound) {
        TextComponent.Builder builder;
        BinaryTag type = compound.get("type");
        if (type instanceof StringBinaryTag) {
            StringBinaryTag sType = (StringBinaryTag)type;
            builder = switch (sType.value()) {
                case "text" -> this.deserializeTextComponent(compound);
                case "translatable" -> this.deserializeTranslatableComponent(compound);
                case "score" -> this.deserializeScoreComponent(compound);
                case "selector" -> this.deserializeSelectorComponent(compound);
                case "keybind" -> this.deserializeKeybindComponent(compound);
                case "nbt" -> this.deserializeNbtComponent(compound);
                default -> throw new UnsupportedOperationException("Unknown component type: " + String.valueOf(type));
            };
        } else {
            Set keys = compound.keySet();
            if (keys.isEmpty()) {
                return Component.empty();
            }
            if (keys.contains("text")) {
                builder = this.deserializeTextComponent(compound);
            } else if (keys.contains("translate")) {
                builder = this.deserializeTranslatableComponent(compound);
            } else if (keys.contains("score")) {
                builder = this.deserializeScoreComponent(compound);
            } else if (keys.contains("selector")) {
                builder = this.deserializeSelectorComponent(compound);
            } else if (keys.contains("keybind")) {
                builder = this.deserializeKeybindComponent(compound);
            } else if (keys.contains("nbt")) {
                builder = this.deserializeNbtComponent(compound);
            } else if (keys.contains("")) {
                builder = Component.text().content(compound.getString(""));
            } else {
                throw new UnsupportedOperationException("Unable to infer component type");
            }
        }
        ListBinaryTag extra = compound.getList("extra", BinaryTagTypes.COMPOUND);
        if (extra.size() > 0) {
            ArrayList<Component> list = new ArrayList<Component>();
            for (BinaryTag child : extra) {
                list.add(this.deserializeAnyComponent(child));
            }
            builder.append(list);
        }
        builder.style(this.deserializeStyle((BinaryTag)compound));
        return builder.build();
    }

    @Override
    @NotNull
    public Style deserializeStyle(@NotNull BinaryTag tag) {
        CompoundBinaryTag hoverEvent;
        CompoundBinaryTag clickEvent;
        String insertion;
        BinaryTag obfuscated;
        BinaryTag strikethrough;
        BinaryTag underlined;
        BinaryTag italic;
        BinaryTag bold;
        String font;
        if (!(tag instanceof CompoundBinaryTag)) {
            return Style.empty();
        }
        CompoundBinaryTag compound = (CompoundBinaryTag)tag;
        Style.Builder style = Style.style();
        String color = compound.getString("color");
        if (!color.isEmpty()) {
            TextColor hexColor = TextColor.fromHexString((String)color);
            if (hexColor != null) {
                style.color(hexColor);
            } else {
                NamedTextColor namedColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)color);
                if (namedColor != null) {
                    style.color((TextColor)namedColor);
                } else {
                    throw new UnsupportedOperationException("Unknown color: " + color);
                }
            }
        }
        if (!(font = compound.getString("font")).isEmpty()) {
            style.font(Key.key((String)font));
        }
        if ((bold = compound.get("bold")) instanceof ByteBinaryTag) {
            ByteBinaryTag b = (ByteBinaryTag)bold;
            style.decoration(TextDecoration.BOLD, b.value() == 1 ? TextDecoration.State.TRUE : TextDecoration.State.FALSE);
        }
        if ((italic = compound.get("italic")) instanceof ByteBinaryTag) {
            ByteBinaryTag b = (ByteBinaryTag)italic;
            style.decoration(TextDecoration.ITALIC, b.value() == 1 ? TextDecoration.State.TRUE : TextDecoration.State.FALSE);
        }
        if ((underlined = compound.get("underlined")) instanceof ByteBinaryTag) {
            ByteBinaryTag b = (ByteBinaryTag)underlined;
            style.decoration(TextDecoration.UNDERLINED, b.value() == 1 ? TextDecoration.State.TRUE : TextDecoration.State.FALSE);
        }
        if ((strikethrough = compound.get("strikethrough")) instanceof ByteBinaryTag) {
            ByteBinaryTag b = (ByteBinaryTag)strikethrough;
            style.decoration(TextDecoration.STRIKETHROUGH, b.value() == 1 ? TextDecoration.State.TRUE : TextDecoration.State.FALSE);
        }
        if ((obfuscated = compound.get("obfuscated")) instanceof ByteBinaryTag) {
            ByteBinaryTag b = (ByteBinaryTag)obfuscated;
            style.decoration(TextDecoration.OBFUSCATED, b.value() == 1 ? TextDecoration.State.TRUE : TextDecoration.State.FALSE);
        }
        if (!(insertion = compound.getString("insertion")).isEmpty()) {
            style.insertion(insertion);
        }
        if ((clickEvent = compound.getCompound("clickEvent")).size() > 0) {
            style.clickEvent(this.deserializeClickEvent(clickEvent));
        }
        if ((hoverEvent = compound.getCompound("hoverEvent")).size() > 0) {
            style.hoverEvent(this.deserializeHoverEvent(hoverEvent));
        }
        return style.build();
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeTextComponent(@NotNull CompoundBinaryTag compound) {
        String text = compound.getString("text");
        Check.notNull(text, "Text component must have a text field");
        return Component.text().content(text);
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeTranslatableComponent(@NotNull CompoundBinaryTag compound) {
        ListBinaryTag args;
        String key = compound.getString("translate");
        Check.notNull(key, "Translatable component must have a translate field");
        TranslatableComponent.Builder builder = Component.translatable().key(key);
        BinaryTag fallback = compound.get("fallback");
        if (fallback instanceof StringBinaryTag) {
            StringBinaryTag s = (StringBinaryTag)fallback;
            builder.fallback(s.value());
        }
        if ((args = compound.getList("with", BinaryTagTypes.COMPOUND)).size() > 0) {
            ArrayList<Component> list = new ArrayList<Component>();
            for (BinaryTag arg : args) {
                list.add(this.deserializeComponent((CompoundBinaryTag)arg));
            }
            builder.arguments(list);
        }
        return builder;
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeScoreComponent(@NotNull CompoundBinaryTag compound) {
        CompoundBinaryTag scoreCompound = compound.getCompound("score");
        Check.notNull(scoreCompound, "Score component must have a score field");
        String name = scoreCompound.getString("name");
        Check.notNull(name, "Score component score field must have a name field");
        String objective = scoreCompound.getString("objective");
        Check.notNull(objective, "Score component score field must have an objective field");
        ScoreComponent.Builder builder = Component.score().name(name).objective(objective);
        String value = scoreCompound.getString("value");
        if (!value.isEmpty()) {
            builder.value(value);
        }
        return builder;
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeSelectorComponent(@NotNull CompoundBinaryTag compound) {
        String selector = compound.getString("selector");
        Check.notNull(selector, "Selector component must have a selector field");
        SelectorComponent.Builder builder = Component.selector().pattern(selector);
        BinaryTag separator = compound.get("separator");
        if (separator != null) {
            builder.separator((ComponentLike)this.deserializeAnyComponent(separator));
        }
        return builder;
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeKeybindComponent(@NotNull CompoundBinaryTag compound) {
        String keybind = compound.getString("keybind");
        Check.notNull(keybind, "Keybind component must have a keybind field");
        return Component.keybind().keybind(keybind);
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeNbtComponent(@NotNull CompoundBinaryTag compound) {
        throw new UnsupportedOperationException("NBTComponent is not implemented yet");
    }

    @NotNull
    private ClickEvent deserializeClickEvent(@NotNull CompoundBinaryTag compound) {
        String actionName = compound.getString("action");
        Check.notNull(actionName, "Click event must have an action field");
        ClickEvent.Action action = (ClickEvent.Action)ClickEvent.Action.NAMES.value((Object)actionName);
        Check.notNull(action, "Unknown click event action: " + actionName);
        String value = compound.getString("value");
        Check.notNull(value, "Click event must have a value field");
        return ClickEvent.clickEvent((ClickEvent.Action)action, (String)value);
    }

    @NotNull
    private HoverEvent<?> deserializeHoverEvent(@NotNull CompoundBinaryTag compound) {
        String actionName = compound.getString("action");
        Check.notNull(actionName, "Hover event must have an action field");
        CompoundBinaryTag contents = compound.getCompound("contents");
        Check.notNull(contents, "Hover event must have a contents field");
        HoverEvent.Action action = (HoverEvent.Action)HoverEvent.Action.NAMES.value((Object)actionName);
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return HoverEvent.showText((Component)this.deserializeComponent(contents));
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            String id = contents.getString("id");
            Check.notNull(id, "Show item hover event must have an id field");
            int count = contents.getInt("count");
            String tag = contents.getString("tag");
            BinaryTagHolder binaryTag = tag.isEmpty() ? null : BinaryTagHolder.binaryTagHolder((String)tag);
            return HoverEvent.showItem((Key)Key.key((String)id), (int)count, (BinaryTagHolder)binaryTag);
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            CompoundBinaryTag name = contents.getCompound("name");
            Component nameComponent = name.size() == 0 ? null : this.deserializeComponent(name);
            String type = contents.getString("type");
            Check.notNull(type, "Show entity hover event must have a type field");
            String id = contents.getString("id");
            Check.notNull(id, "Show entity hover event must have an id field");
            return HoverEvent.showEntity((Key)Key.key((String)type), (UUID)UUID.fromString(id), (Component)nameComponent);
        }
        throw new UnsupportedOperationException("Unknown hover event action: " + actionName);
    }

    @NotNull
    private CompoundBinaryTag serializeComponent(@NotNull Component component) {
        CompoundBinaryTag.Builder compound = CompoundBinaryTag.builder();
        if (component instanceof TextComponent) {
            TextComponent text = (TextComponent)component;
            compound.putString("type", "text");
            compound.putString("text", text.content());
        } else if (component instanceof TranslatableComponent) {
            List args;
            TranslatableComponent translatable = (TranslatableComponent)component;
            compound.putString("type", "translatable");
            compound.putString("translate", translatable.key());
            String fallback = translatable.fallback();
            if (fallback != null) {
                compound.putString("fallback", fallback);
            }
            if (!(args = translatable.arguments()).isEmpty()) {
                compound.put("with", this.serializeTranslationArgs(args));
            }
        } else if (component instanceof ScoreComponent) {
            ScoreComponent score = (ScoreComponent)component;
            compound.putString("type", "score");
            CompoundBinaryTag.Builder scoreCompound = CompoundBinaryTag.builder();
            scoreCompound.putString("name", score.name());
            scoreCompound.putString("objective", score.objective());
            String value = score.value();
            if (value != null) {
                scoreCompound.putString("value", value);
            }
            compound.put("score", (BinaryTag)scoreCompound.build());
        } else if (component instanceof SelectorComponent) {
            SelectorComponent selector = (SelectorComponent)component;
            compound.putString("type", "selector");
            compound.putString("selector", selector.pattern());
            Component separator = selector.separator();
            if (separator != null) {
                compound.put("separator", (BinaryTag)this.serializeComponent(separator));
            }
        } else if (component instanceof KeybindComponent) {
            KeybindComponent keybind = (KeybindComponent)component;
            compound.putString("type", "keybind");
            compound.putString("keybind", keybind.keybind());
        } else {
            if (component instanceof NBTComponent) {
                NBTComponent nbt = (NBTComponent)component;
                throw new UnsupportedOperationException("NBTComponent is not implemented yet");
            }
            throw new UnsupportedOperationException("Unknown component type: " + component.getClass().getName());
        }
        if (!component.children().isEmpty()) {
            ListBinaryTag.Builder children = ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.COMPOUND);
            for (Component child : component.children()) {
                children.add((BinaryTag)this.serializeComponent(child));
            }
            compound.put("extra", (BinaryTag)children.build());
        }
        compound.put(this.serializeStyle(component.style()));
        return compound.build();
    }

    @Override
    @NotNull
    public CompoundBinaryTag serializeStyle(@NotNull Style style) {
        HoverEvent hoverEvent;
        ClickEvent clickEvent;
        String insertion;
        TextDecoration.State obfuscated;
        TextDecoration.State strikethrough;
        TextDecoration.State underlined;
        TextDecoration.State italic;
        TextDecoration.State bold;
        Key font;
        CompoundBinaryTag.Builder compound = CompoundBinaryTag.builder();
        TextColor color = style.color();
        if (color != null) {
            if (color instanceof NamedTextColor) {
                NamedTextColor named = (NamedTextColor)color;
                compound.putString("color", named.toString());
            } else {
                compound.putString("color", color.asHexString());
            }
        }
        if ((font = style.font()) != null) {
            compound.putString("font", font.toString());
        }
        if ((bold = style.decoration(TextDecoration.BOLD)) != TextDecoration.State.NOT_SET) {
            compound.putBoolean("bold", bold == TextDecoration.State.TRUE);
        }
        if ((italic = style.decoration(TextDecoration.ITALIC)) != TextDecoration.State.NOT_SET) {
            compound.putBoolean("italic", italic == TextDecoration.State.TRUE);
        }
        if ((underlined = style.decoration(TextDecoration.UNDERLINED)) != TextDecoration.State.NOT_SET) {
            compound.putBoolean("underlined", underlined == TextDecoration.State.TRUE);
        }
        if ((strikethrough = style.decoration(TextDecoration.STRIKETHROUGH)) != TextDecoration.State.NOT_SET) {
            compound.putBoolean("strikethrough", strikethrough == TextDecoration.State.TRUE);
        }
        if ((obfuscated = style.decoration(TextDecoration.OBFUSCATED)) != TextDecoration.State.NOT_SET) {
            compound.putBoolean("obfuscated", obfuscated == TextDecoration.State.TRUE);
        }
        if ((insertion = style.insertion()) != null) {
            compound.putString("insertion", insertion);
        }
        if ((clickEvent = style.clickEvent()) != null) {
            compound.put("clickEvent", this.serializeClickEvent(clickEvent));
        }
        if ((hoverEvent = style.hoverEvent()) != null) {
            compound.put("hoverEvent", this.serializeHoverEvent(hoverEvent));
        }
        return compound.build();
    }

    @NotNull
    private BinaryTag serializeTranslationArgs(@NotNull Collection<TranslationArgument> args) {
        ListBinaryTag.Builder argList = ListBinaryTag.builder((BinaryTagType)BinaryTagTypes.COMPOUND);
        for (TranslationArgument arg : args) {
            argList.add((BinaryTag)this.serializeComponent(arg.asComponent()));
        }
        return argList.build();
    }

    @NotNull
    private BinaryTag serializeClickEvent(@NotNull ClickEvent event) {
        return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("action", event.action().toString())).putString("value", event.value())).build();
    }

    @NotNull
    private BinaryTag serializeHoverEvent(@NotNull HoverEvent<?> event) {
        CompoundBinaryTag.Builder compound = CompoundBinaryTag.builder();
        compound.putString("action", event.action().toString());
        if (event.action() == HoverEvent.Action.SHOW_TEXT) {
            Component value = (Component)event.value();
            compound.put("contents", (BinaryTag)this.serializeComponent(value));
        } else if (event.action() == HoverEvent.Action.SHOW_ITEM) {
            BinaryTagHolder tag;
            HoverEvent.ShowItem value = (HoverEvent.ShowItem)event.value();
            CompoundBinaryTag.Builder itemCompound = CompoundBinaryTag.builder();
            itemCompound.putString("id", value.item().asString());
            if (value.count() != 1) {
                itemCompound.putInt("count", value.count());
            }
            if ((tag = value.nbt()) != null) {
                itemCompound.putString("tag", tag.string());
            }
            compound.put("contents", (BinaryTag)itemCompound.build());
        } else if (event.action() == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity value = (HoverEvent.ShowEntity)event.value();
            CompoundBinaryTag.Builder entityCompound = CompoundBinaryTag.builder();
            Component name = value.name();
            if (name != null) {
                entityCompound.put("name", (BinaryTag)this.serializeComponent(name));
            }
            entityCompound.putString("type", value.type().asString());
            entityCompound.putString("id", value.id().toString());
            compound.put("contents", (BinaryTag)entityCompound.build());
        } else {
            throw new UnsupportedOperationException("Unknown hover event action: " + String.valueOf(event.action()));
        }
        return compound.build();
    }
}

