/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.MinecraftServer;
import net.minestom.server.instance.block.jukebox.JukeboxSong;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record JukeboxPlayable(@NotNull DynamicRegistry.Key<JukeboxSong> song, boolean showInTooltip) {
    public static final NetworkBuffer.Type<JukeboxPlayable> NETWORK_TYPE = new NetworkBuffer.Type<JukeboxPlayable>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, JukeboxPlayable value) {
            buffer.write(NetworkBuffer.BOOLEAN, true);
            buffer.write(JukeboxSong.NETWORK_TYPE, value.song);
            buffer.write(NetworkBuffer.BOOLEAN, value.showInTooltip);
        }

        @Override
        public JukeboxPlayable read(@NotNull NetworkBuffer buffer) {
            DynamicRegistry.Key<JukeboxSong> song;
            if (buffer.read(NetworkBuffer.BOOLEAN).booleanValue()) {
                song = buffer.read(JukeboxSong.NETWORK_TYPE);
            } else {
                song = DynamicRegistry.Key.of(buffer.read(NetworkBuffer.STRING));
                DynamicRegistry<JukeboxSong> registry = MinecraftServer.getJukeboxSongRegistry();
                Check.stateCondition(registry.get(song) != null, "unknown song: {0}", song);
            }
            return new JukeboxPlayable(song, buffer.read(NetworkBuffer.BOOLEAN));
        }
    };
    public static final BinaryTagSerializer<JukeboxPlayable> NBT_TYPE = new BinaryTagSerializer<JukeboxPlayable>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull BinaryTagSerializer.Context context, @NotNull JukeboxPlayable value) {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("song", JukeboxSong.NBT_TYPE.write(context, value.song))).putBoolean("show_in_tooltip", value.showInTooltip)).build();
        }

        @Override
        @NotNull
        public JukeboxPlayable read(@NotNull BinaryTagSerializer.Context context, @NotNull BinaryTag raw) {
            if (!(raw instanceof CompoundBinaryTag)) {
                throw new IllegalArgumentException("expected compound tag");
            }
            CompoundBinaryTag tag = (CompoundBinaryTag)raw;
            return new JukeboxPlayable(JukeboxSong.NBT_TYPE.read(context, tag.get("song")), tag.getBoolean("show_in_tooltip"));
        }
    };

    public JukeboxPlayable(@NotNull DynamicRegistry.Key<JukeboxSong> song) {
        this(song, true);
    }

    @NotNull
    public JukeboxPlayable withSong(@NotNull DynamicRegistry.Key<JukeboxSong> song) {
        return new JukeboxPlayable(song, this.showInTooltip);
    }

    @NotNull
    public JukeboxPlayable withTooltip(boolean showInTooltip) {
        return new JukeboxPlayable(this.song, showInTooltip);
    }
}

