/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.ping;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ping.ResponseData;
import net.minestom.server.utils.identity.NamedAndIdentified;
import org.jetbrains.annotations.NotNull;

public enum ServerListPingType {
    MODERN_FULL_RGB(data -> ServerListPingType.getModernPingResponse(data, true).toString()),
    MODERN_NAMED_COLORS(data -> ServerListPingType.getModernPingResponse(data, false).toString()),
    LEGACY_VERSIONED(data -> ServerListPingType.getLegacyPingResponse(data, true)),
    LEGACY_UNVERSIONED(data -> ServerListPingType.getLegacyPingResponse(data, false)),
    OPEN_TO_LAN(ServerListPingType::getOpenToLANPing);

    private final Function<ResponseData, String> pingResponseCreator;
    private static final String LAN_PING_FORMAT = "[MOTD]%s[/MOTD][AD]%s[/AD]";
    private static final GsonComponentSerializer FULL_RGB;
    private static final GsonComponentSerializer NAMED_RGB;
    private static final LegacyComponentSerializer SECTION;

    private ServerListPingType(Function<ResponseData, String> pingResponseCreator) {
        this.pingResponseCreator = pingResponseCreator;
    }

    @NotNull
    public String getPingResponse(@NotNull ResponseData responseData) {
        return this.pingResponseCreator.apply(responseData);
    }

    @NotNull
    public static String getOpenToLANPing(@NotNull ResponseData data) {
        return String.format(LAN_PING_FORMAT, SECTION.serialize(data.getDescription()), MinecraftServer.getServer().getPort());
    }

    @NotNull
    public static String getLegacyPingResponse(@NotNull ResponseData data, boolean supportsVersions) {
        String motd = SECTION.serialize(data.getDescription());
        if (supportsVersions) {
            return String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", data.getProtocol(), data.getVersion(), motd, data.getOnline(), data.getMaxPlayer());
        }
        return String.format("%s\u00a7%d\u00a7%d", motd, data.getOnline(), data.getMaxPlayer());
    }

    @NotNull
    public static JsonObject getModernPingResponse(@NotNull ResponseData data, boolean supportsFullRgb) {
        JsonObject versionObject = new JsonObject();
        versionObject.addProperty("name", data.getVersion());
        versionObject.addProperty("protocol", (Number)data.getProtocol());
        JsonObject playersObject = null;
        if (!data.arePlayersHidden()) {
            playersObject = new JsonObject();
            playersObject.addProperty("max", (Number)data.getMaxPlayer());
            playersObject.addProperty("online", (Number)data.getOnline());
            JsonArray sampleArray = new JsonArray();
            for (NamedAndIdentified entry : data.getEntries()) {
                JsonObject playerObject = new JsonObject();
                playerObject.addProperty("name", SECTION.serialize(entry.getName()));
                playerObject.addProperty("id", entry.getUuid().toString());
                sampleArray.add((JsonElement)playerObject);
            }
            playersObject.add("sample", (JsonElement)sampleArray);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("version", (JsonElement)versionObject);
        jsonObject.add("players", (JsonElement)playersObject);
        jsonObject.addProperty("favicon", data.getFavicon());
        if (supportsFullRgb) {
            jsonObject.add("description", FULL_RGB.serializeToTree(data.getDescription()));
        } else {
            jsonObject.add("description", NAMED_RGB.serializeToTree(data.getDescription()));
        }
        return jsonObject;
    }

    @NotNull
    public static ServerListPingType fromModernProtocolVersion(int version) {
        if (version >= 713) {
            return MODERN_FULL_RGB;
        }
        return MODERN_NAMED_COLORS;
    }

    static {
        FULL_RGB = GsonComponentSerializer.gson();
        NAMED_RGB = GsonComponentSerializer.colorDownsamplingGson();
        SECTION = LegacyComponentSerializer.legacySection();
    }
}

