/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.armor;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minestom.server.item.Material;
import net.minestom.server.item.armor.TrimMaterial;
import net.minestom.server.item.armor.TrimPattern;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTType;

public class TrimManager {
    private final Set<TrimMaterial> trimMaterials = new HashSet<TrimMaterial>();
    private final Set<TrimPattern> trimPatterns = new HashSet<TrimPattern>();
    private NBTCompound trimMaterialCache = null;
    private NBTCompound trimPatternCache = null;

    @Nullable
    public TrimMaterial fromIngredient(Material ingredient) {
        return this.trimMaterials.stream().filter(trimMaterial -> trimMaterial.ingredient().equals(ingredient)).findFirst().orElse(null);
    }

    @Nullable
    public TrimPattern fromTemplate(Material material) {
        return this.trimPatterns.stream().filter(trimPattern -> trimPattern.template().equals(material)).findFirst().orElse(null);
    }

    public NBTCompound getTrimMaterialNBT() {
        if (this.trimMaterialCache == null) {
            List<NBTCompound> trimMaterials = this.trimMaterials.stream().map(trimMaterial -> NBT.Compound(Map.of("id", NBT.Int((int)trimMaterial.id()), "name", NBT.String((String)trimMaterial.name()), "element", trimMaterial.asNBT()))).toList();
            this.trimMaterialCache = NBT.Compound(Map.of("type", NBT.String((String)"minecraft:trim_material"), "value", NBT.List((NBTType)NBTType.TAG_Compound, trimMaterials)));
        }
        return this.trimMaterialCache;
    }

    public NBTCompound getTrimPatternNBT() {
        if (this.trimPatternCache == null) {
            List<NBTCompound> trimPatterns = this.trimPatterns.stream().map(trimPattern -> NBT.Compound(Map.of("id", NBT.Int((int)trimPattern.id()), "name", NBT.String((String)trimPattern.name()), "element", trimPattern.asNBT()))).toList();
            this.trimPatternCache = NBT.Compound(Map.of("type", NBT.String((String)"minecraft:trim_pattern"), "value", NBT.List((NBTType)NBTType.TAG_Compound, trimPatterns)));
        }
        return this.trimPatternCache;
    }

    public Set<TrimMaterial> getTrimMaterials() {
        return Set.copyOf(this.trimMaterials);
    }

    public Set<TrimPattern> getTrimPatterns() {
        return Set.copyOf(this.trimPatterns);
    }

    public void addDefaultTrimMaterials() {
        this.trimMaterialCache = null;
        this.trimMaterials.addAll(TrimMaterial.values());
    }

    public void addDefaultTrimPatterns() {
        this.trimPatternCache = null;
        this.trimPatterns.addAll(TrimPattern.values());
    }

    public boolean addTrimMaterial(TrimMaterial trimMaterial) {
        this.trimMaterialCache = null;
        return this.trimMaterials.add(trimMaterial);
    }

    public boolean removeTrimMaterial(TrimMaterial trimMaterial) {
        this.trimMaterialCache = null;
        return this.trimMaterials.remove(trimMaterial);
    }

    public boolean addTrimPattern(TrimPattern trimPattern) {
        this.trimPatternCache = null;
        return this.trimPatterns.add(trimPattern);
    }

    public boolean removeTrimPattern(TrimPattern trimPattern) {
        this.trimPatternCache = null;
        return this.trimPatterns.remove(trimPattern);
    }
}

