/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import com.extollit.gaming.ai.path.model.ColumnarOcclusionFieldList;
import com.extollit.gaming.ai.path.model.IBlockDescription;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minestom.server.MinecraftServer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.pathfinding.PFBlock;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.heightmap.Heightmap;
import net.minestom.server.instance.heightmap.MotionBlockingHeightmap;
import net.minestom.server.instance.heightmap.WorldSurfaceHeightmap;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.play.ChunkDataPacket;
import net.minestom.server.network.packet.server.play.UpdateLightPacket;
import net.minestom.server.network.packet.server.play.data.ChunkData;
import net.minestom.server.network.packet.server.play.data.LightData;
import net.minestom.server.snapshot.ChunkSnapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.utils.ArrayUtils;
import net.minestom.server.utils.chunk.ChunkUtils;
import net.minestom.server.world.biomes.Biome;
import net.minestom.server.world.biomes.BiomeManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicChunk
extends Chunk {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicChunk.class);
    protected List<Section> sections;
    private boolean needsCompleteHeightmapRefresh = true;
    protected Heightmap motionBlocking = new MotionBlockingHeightmap(this);
    protected Heightmap worldSurface = new WorldSurfaceHeightmap(this);
    protected final Int2ObjectOpenHashMap<Block> entries = new Int2ObjectOpenHashMap(0);
    protected final Int2ObjectOpenHashMap<Block> tickableMap = new Int2ObjectOpenHashMap(0);
    private long lastChange;
    final CachedPacket chunkCache = new CachedPacket(this::createChunkPacket);
    private static final BiomeManager BIOME_MANAGER = MinecraftServer.getBiomeManager();

    public DynamicChunk(@NotNull Instance instance, int chunkX, int chunkZ) {
        super(instance, chunkX, chunkZ, true);
        Section[] sectionsTemp = new Section[this.maxSection - this.minSection];
        Arrays.setAll(sectionsTemp, value -> new Section());
        this.sections = List.of(sectionsTemp);
    }

    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block, @Nullable BlockHandler.Placement placement, @Nullable BlockHandler.Destroy destroy) {
        if (y >= this.instance.getDimensionType().getMaxY() || y < this.instance.getDimensionType().getMinY()) {
            LOGGER.warn("tried to set a block outside the world bounds, should be within [{}, {}): {}", new Object[]{this.instance.getDimensionType().getMinY(), this.instance.getDimensionType().getMaxY(), y});
            return;
        }
        this.assertLock();
        this.lastChange = System.currentTimeMillis();
        this.chunkCache.invalidate();
        if (this.columnarSpace != null) {
            ColumnarOcclusionFieldList columnarOcclusionFieldList = this.columnarSpace.occlusionFields();
            PFBlock blockDescription = PFBlock.get(block);
            columnarOcclusionFieldList.onBlockChanged(x, y, z, (IBlockDescription)blockDescription, 0);
        }
        Section section = this.getSectionAt(y);
        int sectionRelativeX = ChunkUtils.toSectionRelativeCoordinate(x);
        int sectionRelativeZ = ChunkUtils.toSectionRelativeCoordinate(z);
        section.blockPalette().set(sectionRelativeX, ChunkUtils.toSectionRelativeCoordinate(y), sectionRelativeZ, block.stateId());
        int index = ChunkUtils.getBlockIndex(x, y, z);
        BlockHandler handler = block.handler();
        Block lastCachedBlock = handler != null || block.hasNbt() || block.registry().isBlockEntity() ? (Block)this.entries.put(index, (Object)block) : (Block)this.entries.remove(index);
        if (handler != null && handler.isTickable()) {
            this.tickableMap.put(index, (Object)block);
        } else {
            this.tickableMap.remove(index);
        }
        Vec blockPosition = new Vec(x, y, z);
        if (lastCachedBlock != null && lastCachedBlock.handler() != null) {
            lastCachedBlock.handler().onDestroy(Objects.requireNonNullElseGet(destroy, () -> new BlockHandler.Destroy(lastCachedBlock, this.instance, blockPosition)));
        }
        if (handler != null) {
            Block finalBlock = block;
            handler.onPlace(Objects.requireNonNullElseGet(placement, () -> new BlockHandler.Placement(finalBlock, this.instance, blockPosition)));
        }
        if (this.needsCompleteHeightmapRefresh) {
            this.calculateFullHeightmap();
        }
        this.motionBlocking.refresh(sectionRelativeX, y, sectionRelativeZ, block);
        this.worldSurface.refresh(sectionRelativeX, y, sectionRelativeZ, block);
    }

    @Override
    public void setBiome(int x, int y, int z, @NotNull Biome biome) {
        this.assertLock();
        this.chunkCache.invalidate();
        Section section = this.getSectionAt(y);
        int id = BIOME_MANAGER.getId(biome);
        if (id == -1) {
            throw new IllegalStateException("Biome has not been registered: " + String.valueOf(biome.namespace()));
        }
        section.biomePalette().set(ChunkUtils.toSectionRelativeCoordinate(x) / 4, ChunkUtils.toSectionRelativeCoordinate(y) / 4, ChunkUtils.toSectionRelativeCoordinate(z) / 4, id);
    }

    @Override
    @NotNull
    public List<Section> getSections() {
        return this.sections;
    }

    @Override
    @NotNull
    public Section getSection(int section) {
        return this.sections.get(section - this.minSection);
    }

    @Override
    @NotNull
    public Heightmap motionBlockingHeightmap() {
        return this.motionBlocking;
    }

    @Override
    @NotNull
    public Heightmap worldSurfaceHeightmap() {
        return this.worldSurface;
    }

    @Override
    public void loadHeightmapsFromNBT(NBTCompound heightmapsNBT) {
        if (heightmapsNBT.contains(this.motionBlockingHeightmap().NBTName())) {
            this.motionBlockingHeightmap().loadFrom(heightmapsNBT.getLongArray(this.motionBlockingHeightmap().NBTName()));
        }
        if (heightmapsNBT.contains(this.worldSurfaceHeightmap().NBTName())) {
            this.worldSurfaceHeightmap().loadFrom(heightmapsNBT.getLongArray(this.worldSurfaceHeightmap().NBTName()));
        }
    }

    @Override
    public void tick(long time) {
        if (this.tickableMap.isEmpty()) {
            return;
        }
        this.tickableMap.int2ObjectEntrySet().fastForEach(entry -> {
            int index = entry.getIntKey();
            Block block = (Block)entry.getValue();
            BlockHandler handler = block.handler();
            if (handler == null) {
                return;
            }
            Point blockPosition = ChunkUtils.getBlockPosition(index, this.chunkX, this.chunkZ);
            handler.tick(new BlockHandler.Tick(block, this.instance, blockPosition));
        });
    }

    @Override
    @Nullable
    public Block getBlock(int x, int y, int z, @NotNull Block.Getter.Condition condition) {
        this.assertLock();
        if (y < this.minSection * 16 || y >= this.maxSection * 16) {
            return Block.AIR;
        }
        if (condition != Block.Getter.Condition.TYPE) {
            Block entry;
            Block block = entry = !this.entries.isEmpty() ? (Block)this.entries.get(ChunkUtils.getBlockIndex(x, y, z)) : null;
            if (entry != null || condition == Block.Getter.Condition.CACHED) {
                return entry;
            }
        }
        Section section = this.getSectionAt(y);
        int blockStateId = section.blockPalette().get(ChunkUtils.toSectionRelativeCoordinate(x), ChunkUtils.toSectionRelativeCoordinate(y), ChunkUtils.toSectionRelativeCoordinate(z));
        return Objects.requireNonNullElse(Block.fromStateId((short)blockStateId), Block.AIR);
    }

    @Override
    @NotNull
    public Biome getBiome(int x, int y, int z) {
        this.assertLock();
        Section section = this.getSectionAt(y);
        int id = section.biomePalette().get(ChunkUtils.toSectionRelativeCoordinate(x) / 4, ChunkUtils.toSectionRelativeCoordinate(y) / 4, ChunkUtils.toSectionRelativeCoordinate(z) / 4);
        Biome biome = BIOME_MANAGER.getById(id);
        if (biome == null) {
            throw new IllegalStateException("Biome with id " + id + " is not registered");
        }
        return biome;
    }

    @Override
    public long getLastChangeTime() {
        return this.lastChange;
    }

    @Override
    @NotNull
    public SendablePacket getFullDataPacket() {
        return this.chunkCache;
    }

    @Override
    @NotNull
    public Chunk copy(@NotNull Instance instance, int chunkX, int chunkZ) {
        DynamicChunk dynamicChunk = new DynamicChunk(instance, chunkX, chunkZ);
        dynamicChunk.sections = this.sections.stream().map(Section::clone).toList();
        dynamicChunk.entries.putAll(this.entries);
        return dynamicChunk;
    }

    @Override
    public void reset() {
        for (Section section : this.sections) {
            section.clear();
        }
        this.entries.clear();
    }

    @Override
    public void invalidate() {
        this.chunkCache.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ChunkDataPacket createChunkPacket() {
        byte[] data;
        NBTCompound heightmapsNBT;
        DynamicChunk dynamicChunk = this;
        synchronized (dynamicChunk) {
            heightmapsNBT = this.getHeightmapNBT();
            data = NetworkBuffer.makeArray(networkBuffer -> {
                for (Section section : this.sections) {
                    networkBuffer.write(section);
                }
            });
        }
        return new ChunkDataPacket(this.chunkX, this.chunkZ, new ChunkData(heightmapsNBT, data, (Map<Integer, Block>)this.entries), this.createLightData());
    }

    @NotNull
    UpdateLightPacket createLightPacket() {
        return new UpdateLightPacket(this.chunkX, this.chunkZ, this.createLightData());
    }

    protected LightData createLightData() {
        BitSet skyMask = new BitSet();
        BitSet blockMask = new BitSet();
        BitSet emptySkyMask = new BitSet();
        BitSet emptyBlockMask = new BitSet();
        ArrayList<byte[]> skyLights = new ArrayList<byte[]>();
        ArrayList<byte[]> blockLights = new ArrayList<byte[]>();
        int index = 0;
        for (Section section : this.sections) {
            ++index;
            byte[] skyLight = section.skyLight().array();
            byte[] blockLight = section.blockLight().array();
            if (skyLight.length != 0) {
                skyLights.add(skyLight);
                skyMask.set(index);
            } else {
                emptySkyMask.set(index);
            }
            if (blockLight.length != 0) {
                blockLights.add(blockLight);
                blockMask.set(index);
                continue;
            }
            emptyBlockMask.set(index);
        }
        return new LightData(skyMask, blockMask, emptySkyMask, emptyBlockMask, skyLights, blockLights);
    }

    private NBTCompound getHeightmapNBT() {
        if (this.needsCompleteHeightmapRefresh) {
            this.calculateFullHeightmap();
        }
        return NBT.Compound(Map.of(this.motionBlocking.NBTName(), this.motionBlocking.getNBT(), this.worldSurface.NBTName(), this.worldSurface.getNBT()));
    }

    private void calculateFullHeightmap() {
        int startY = Heightmap.getHighestBlockSection(this);
        this.motionBlocking.refresh(startY);
        this.worldSurface.refresh(startY);
        this.needsCompleteHeightmapRefresh = false;
    }

    @Override
    @NotNull
    public ChunkSnapshot updateSnapshot(@NotNull SnapshotUpdater updater) {
        Section[] clonedSections = new Section[this.sections.size()];
        for (int i = 0; i < clonedSections.length; ++i) {
            clonedSections[i] = this.sections.get(i).clone();
        }
        Collection<Entity> entities = this.instance.getEntityTracker().chunkEntities(this.chunkX, this.chunkZ, EntityTracker.Target.ENTITIES);
        int[] entityIds = ArrayUtils.mapToIntArray(entities, Entity::getEntityId);
        return new SnapshotImpl.Chunk(this.minSection, this.chunkX, this.chunkZ, clonedSections, (Int2ObjectOpenHashMap<Block>)this.entries.clone(), entityIds, updater.reference(this.instance), this.tagHandler().readableCopy());
    }

    private void assertLock() {
        assert (Thread.holdsLock(this)) : "Chunk must be locked before access";
    }
}

