/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record UnloadChunkPacket(int chunkX, int chunkZ) implements ServerPacket
{
    public UnloadChunkPacket(@NotNull NetworkBuffer reader) {
        this(UnloadChunkPacket.read(reader));
    }

    private UnloadChunkPacket(@NotNull UnloadChunkPacket other) {
        this(other.chunkX(), other.chunkZ());
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.INT, this.chunkZ);
        writer.write(NetworkBuffer.INT, this.chunkX);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.UNLOAD_CHUNK;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    private static UnloadChunkPacket read(@NotNull NetworkBuffer reader) {
        int z = reader.read(NetworkBuffer.INT);
        int x = reader.read(NetworkBuffer.INT);
        return new UnloadChunkPacket(x, z);
    }
}

