/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import java.util.function.Function;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record DeclareCommandsPacket(@NotNull List<Node> nodes, int rootIndex) implements ServerPacket
{
    public static final int MAX_NODES = Short.MAX_VALUE;

    public DeclareCommandsPacket(@NotNull List<Node> nodes, int rootIndex) {
        nodes = List.copyOf(nodes);
    }

    public DeclareCommandsPacket(@NotNull NetworkBuffer reader) {
        this(reader.readCollection(r -> {
            Node node = new Node();
            node.read((NetworkBuffer)r);
            return node;
        }, Short.MAX_VALUE), reader.read(NetworkBuffer.VAR_INT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeCollection(this.nodes);
        writer.write(NetworkBuffer.VAR_INT, this.rootIndex);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.DECLARE_COMMANDS;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }

    public static byte getFlag(@NotNull NodeType type, boolean executable, boolean redirect, boolean suggestionType) {
        byte result = (byte)type.ordinal();
        if (executable) {
            result = (byte)(result | 4);
        }
        if (redirect) {
            result = (byte)(result | 8);
        }
        if (suggestionType) {
            result = (byte)(result | 0x10);
        }
        return result;
    }

    public static enum NodeType {
        ROOT,
        LITERAL,
        ARGUMENT,
        NONE;

    }

    public static final class Node
    implements NetworkBuffer.Writer {
        public byte flags;
        public int[] children = new int[0];
        public int redirectedNode;
        public String name = "";
        public String parser;
        public byte[] properties;
        public String suggestionsType = "";

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.BYTE, this.flags);
            if (this.children != null && this.children.length > 262114) {
                throw new RuntimeException("Children length " + this.children.length + " is bigger than the maximum allowed 262114");
            }
            writer.write(NetworkBuffer.VAR_INT_ARRAY, this.children);
            if ((this.flags & 8) != 0) {
                writer.write(NetworkBuffer.VAR_INT, this.redirectedNode);
            }
            if (this.isLiteral() || this.isArgument()) {
                writer.write(NetworkBuffer.STRING, this.name);
            }
            if (this.isArgument()) {
                int parserId = Argument.CONTAINER.toId(this.parser);
                writer.write(NetworkBuffer.VAR_INT, parserId);
                if (this.properties != null) {
                    writer.write(NetworkBuffer.RAW_BYTES, this.properties);
                }
            }
            if ((this.flags & 0x10) != 0) {
                writer.write(NetworkBuffer.STRING, this.suggestionsType);
            }
        }

        public void read(@NotNull NetworkBuffer reader) {
            this.flags = reader.read(NetworkBuffer.BYTE);
            this.children = reader.read(NetworkBuffer.VAR_INT_ARRAY);
            if ((this.flags & 8) != 0) {
                this.redirectedNode = reader.read(NetworkBuffer.VAR_INT);
            }
            if (this.isLiteral() || this.isArgument()) {
                this.name = reader.read(NetworkBuffer.STRING);
            }
            if (this.isArgument()) {
                Argument.ArgumentImpl object = Argument.CONTAINER.getId(reader.read(NetworkBuffer.VAR_INT));
                this.parser = object.name();
                this.properties = this.getProperties(reader, this.parser);
            }
            if ((this.flags & 0x10) != 0) {
                this.suggestionsType = reader.read(NetworkBuffer.STRING);
            }
        }

        private byte[] getProperties(@NotNull NetworkBuffer reader, String parser) {
            Function<Function, byte[]> minMaxExtractor = via -> reader.extractBytes(extractor -> {
                byte flags = extractor.read(NetworkBuffer.BYTE);
                if ((flags & 1) == 1) {
                    via.apply(extractor);
                }
                if ((flags & 2) == 2) {
                    via.apply(extractor);
                }
            });
            return switch (parser) {
                case "brigadier:double" -> minMaxExtractor.apply(b -> b.read(NetworkBuffer.DOUBLE));
                case "brigadier:integer" -> minMaxExtractor.apply(b -> b.read(NetworkBuffer.INT));
                case "brigadier:float" -> minMaxExtractor.apply(b -> b.read(NetworkBuffer.FLOAT));
                case "brigadier:long" -> minMaxExtractor.apply(b -> b.read(NetworkBuffer.LONG));
                case "brigadier:string" -> reader.extractBytes(b -> b.read(NetworkBuffer.VAR_INT));
                case "minecraft:entity", "minecraft:score_holder" -> reader.extractBytes(b -> b.read(NetworkBuffer.BYTE));
                case "minecraft:range" -> reader.extractBytes(b -> b.read(NetworkBuffer.BOOLEAN));
                case "minecraft:resource_or_tag", "minecraft:registry" -> reader.extractBytes(b -> b.read(NetworkBuffer.STRING));
                default -> new byte[]{};
            };
        }

        private boolean isLiteral() {
            return (this.flags & 1) != 0;
        }

        private boolean isArgument() {
            return (this.flags & 2) != 0;
        }
    }
}

