/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record BlockChangePacket(@NotNull Point blockPosition, int blockStateId) implements ServerPacket
{
    public BlockChangePacket(@NotNull Point blockPosition, @NotNull Block block) {
        this(blockPosition, block.stateId());
    }

    public BlockChangePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BLOCK_POSITION), reader.read(NetworkBuffer.VAR_INT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BLOCK_POSITION, this.blockPosition);
        writer.write(NetworkBuffer.VAR_INT, this.blockStateId);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.BLOCK_CHANGE;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

