/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.Objects;
import java.util.function.Consumer;
import net.minestom.server.item.ItemMeta;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

record ItemMetaImpl(TagHandler tagHandler) implements ItemMeta
{
    static final ItemMetaImpl EMPTY = new ItemMetaImpl(TagHandler.newHandler());

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.tagHandler.getTag(tag);
    }

    @Override
    @NotNull
    public ItemMeta with(@NotNull @NotNull Consumer<@NotNull ItemMeta.Builder> builderConsumer) {
        Builder builder = new Builder(this.tagHandler.copy());
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    @NotNull
    public NBTCompound toNBT() {
        return this.tagHandler.asCompound();
    }

    @Override
    @NotNull
    public String toSNBT() {
        return this.toNBT().toSNBT();
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        NBTCompound nbt = this.toNBT();
        if (nbt.isEmpty()) {
            writer.write(NetworkBuffer.BYTE, (byte)0);
            return;
        }
        writer.write(NetworkBuffer.NBT, nbt);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemMetaImpl)) {
            return false;
        }
        ItemMetaImpl itemMeta = (ItemMetaImpl)o;
        return this.toNBT().equals((Object)itemMeta.toNBT());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.toNBT());
    }

    @Override
    public String toString() {
        return this.toSNBT();
    }

    record Builder(TagHandler tagHandler) implements ItemMeta.Builder
    {
        @Override
        @NotNull
        public ItemMetaImpl build() {
            return new ItemMetaImpl(this.tagHandler.copy());
        }
    }
}

