/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.serializer.nbt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.KeybindComponent;
import net.kyori.adventure.text.NBTComponent;
import net.kyori.adventure.text.ScoreComponent;
import net.kyori.adventure.text.SelectorComponent;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minestom.server.adventure.serializer.nbt.NbtComponentSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTType;
import org.jglrxavpok.hephaistos.nbt.mutable.MutableNBTCompound;

final class NbtComponentSerializerImpl
implements NbtComponentSerializer {
    static final NbtComponentSerializer INSTANCE = new NbtComponentSerializerImpl();

    NbtComponentSerializerImpl() {
    }

    @NotNull
    public Component deserialize(@NotNull NBT input) {
        return this.deserializeAnyComponent(input);
    }

    @NotNull
    public NBT serialize(@NotNull Component component) {
        return this.serializeComponent(component);
    }

    @NotNull
    private Component deserializeAnyComponent(@NotNull NBT nbt) {
        if (nbt instanceof NBTCompound) {
            NBTCompound compound = (NBTCompound)nbt;
            return this.deserializeComponent(compound);
        }
        throw new UnsupportedOperationException("Unknown NBT type: " + nbt.getClass().getName());
    }

    @NotNull
    private Component deserializeComponent(@NotNull NBTCompound compound) {
        NBTCompound hoverEvent;
        NBTCompound clickEvent;
        Byte obfuscated;
        Byte strikethrough;
        Byte underlined;
        Byte italic;
        Byte bold;
        String font;
        ComponentBuilder<?, ?> builder;
        String type = compound.getString("type");
        if (type != null) {
            builder = switch (type) {
                case "text" -> this.deserializeTextComponent(compound);
                case "translatable" -> this.deserializeTranslatableComponent(compound);
                case "score" -> this.deserializeScoreComponent(compound);
                case "selector" -> this.deserializeSelectorComponent(compound);
                case "keybind" -> this.deserializeKeybindComponent(compound);
                case "nbt" -> this.deserializeNbtComponent(compound);
                default -> throw new UnsupportedOperationException("Unknown component type: " + type);
            };
        } else if (compound.containsKey("text")) {
            builder = this.deserializeTextComponent(compound);
        } else if (compound.containsKey("translate")) {
            builder = this.deserializeTranslatableComponent(compound);
        } else if (compound.containsKey("score")) {
            builder = this.deserializeScoreComponent(compound);
        } else if (compound.containsKey("selector")) {
            builder = this.deserializeSelectorComponent(compound);
        } else if (compound.containsKey("keybind")) {
            builder = this.deserializeKeybindComponent(compound);
        } else if (compound.containsKey("nbt")) {
            builder = this.deserializeNbtComponent(compound);
        } else {
            throw new UnsupportedOperationException("Unable to infer component type");
        }
        NBTList extra = compound.getList("extra");
        Check.argCondition(extra != null && !extra.getSubtagType().equals(NBTType.TAG_Compound), "Extra field must be a list of compounds");
        if (extra != null) {
            ArrayList<Component> list = new ArrayList<Component>();
            for (NBT child : extra) {
                list.add(this.deserializeAnyComponent(child));
            }
            builder.append(list);
        }
        Style.Builder style = Style.style();
        String color = compound.getString("color");
        if (color != null) {
            TextColor hexColor = TextColor.fromHexString((String)color);
            if (hexColor != null) {
                style.color(hexColor);
            } else {
                NamedTextColor namedColor = (NamedTextColor)NamedTextColor.NAMES.value((Object)color);
                if (namedColor != null) {
                    style.color((TextColor)namedColor);
                } else {
                    throw new UnsupportedOperationException("Unknown color: " + color);
                }
            }
        }
        if ((font = compound.getString("font")) != null) {
            style.font(Key.key((String)font));
        }
        if ((bold = compound.getByte("bold")) != null) {
            style.decoration(TextDecoration.BOLD, bold == 1 ? TextDecoration.State.TRUE : TextDecoration.State.FALSE);
        }
        if ((italic = compound.getByte("italic")) != null) {
            style.decoration(TextDecoration.ITALIC, italic == 1 ? TextDecoration.State.TRUE : TextDecoration.State.FALSE);
        }
        if ((underlined = compound.getByte("underlined")) != null) {
            style.decoration(TextDecoration.UNDERLINED, underlined == 1 ? TextDecoration.State.TRUE : TextDecoration.State.FALSE);
        }
        if ((strikethrough = compound.getByte("strikethrough")) != null) {
            style.decoration(TextDecoration.STRIKETHROUGH, strikethrough == 1 ? TextDecoration.State.TRUE : TextDecoration.State.FALSE);
        }
        if ((obfuscated = compound.getByte("obfuscated")) != null) {
            style.decoration(TextDecoration.OBFUSCATED, obfuscated == 1 ? TextDecoration.State.TRUE : TextDecoration.State.FALSE);
        }
        builder.style(style.build());
        String insertion = compound.getString("insertion");
        if (insertion != null) {
            builder.insertion(insertion);
        }
        if ((clickEvent = compound.getCompound("clickEvent")) != null) {
            builder.clickEvent(this.deserializeClickEvent(clickEvent));
        }
        if ((hoverEvent = compound.getCompound("hoverEvent")) != null) {
            builder.hoverEvent(this.deserializeHoverEvent(hoverEvent));
        }
        return builder.build();
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeTextComponent(@NotNull NBTCompound compound) {
        String text = compound.getString("text");
        Check.notNull(text, "Text component must have a text field");
        return Component.text().content(text);
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeTranslatableComponent(@NotNull NBTCompound compound) {
        NBTList args;
        String key = compound.getString("translate");
        Check.notNull(key, "Translatable component must have a translate field");
        TranslatableComponent.Builder builder = Component.translatable().key(key);
        String fallback = compound.getString("fallback");
        if (fallback != null) {
            builder.fallback(fallback);
        }
        Check.argCondition((args = compound.getList("with")) != null && !args.getSubtagType().equals(NBTType.TAG_Compound), "Translatable component with field must be a list of compounds");
        if (args != null) {
            ArrayList<Component> list = new ArrayList<Component>();
            for (NBTCompound arg : args) {
                list.add(this.deserializeComponent(arg));
            }
            builder.arguments(list);
        }
        return builder;
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeScoreComponent(@NotNull NBTCompound compound) {
        NBTCompound scoreCompound = compound.getCompound("score");
        Check.notNull(scoreCompound, "Score component must have a score field");
        String name = scoreCompound.getString("name");
        Check.notNull(name, "Score component score field must have a name field");
        String objective = scoreCompound.getString("objective");
        Check.notNull(objective, "Score component score field must have an objective field");
        ScoreComponent.Builder builder = Component.score().name(name).objective(objective);
        String value = scoreCompound.getString("value");
        if (value != null) {
            builder.value(value);
        }
        return builder;
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeSelectorComponent(@NotNull NBTCompound compound) {
        String selector = compound.getString("selector");
        Check.notNull(selector, "Selector component must have a selector field");
        SelectorComponent.Builder builder = Component.selector().pattern(selector);
        NBT separator = compound.get("separator");
        if (separator != null) {
            builder.separator((ComponentLike)this.deserializeAnyComponent(separator));
        }
        return builder;
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeKeybindComponent(@NotNull NBTCompound compound) {
        String keybind = compound.getString("keybind");
        Check.notNull(keybind, "Keybind component must have a keybind field");
        return Component.keybind().keybind(keybind);
    }

    @NotNull
    private ComponentBuilder<?, ?> deserializeNbtComponent(@NotNull NBTCompound compound) {
        throw new UnsupportedOperationException("NBTComponent is not implemented yet");
    }

    @NotNull
    private ClickEvent deserializeClickEvent(@NotNull NBTCompound compound) {
        String actionName = compound.getString("action");
        Check.notNull(actionName, "Click event must have an action field");
        ClickEvent.Action action = (ClickEvent.Action)ClickEvent.Action.NAMES.value((Object)actionName);
        Check.notNull(action, "Unknown click event action: " + actionName);
        String value = compound.getString("value");
        Check.notNull(value, "Click event must have a value field");
        return ClickEvent.clickEvent((ClickEvent.Action)action, (String)value);
    }

    @NotNull
    private HoverEvent<?> deserializeHoverEvent(@NotNull NBTCompound compound) {
        String actionName = compound.getString("action");
        Check.notNull(actionName, "Hover event must have an action field");
        NBTCompound contents = compound.getCompound("contents");
        Check.notNull(contents, "Hover event must have a contents field");
        HoverEvent.Action action = (HoverEvent.Action)HoverEvent.Action.NAMES.value((Object)actionName);
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return HoverEvent.showText((Component)this.deserializeComponent(contents));
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            String id = contents.getString("id");
            Check.notNull(id, "Show item hover event must have an id field");
            Integer count = contents.getInt("count");
            int countInt = count == null ? 1 : count;
            String tag = contents.getString("tag");
            BinaryTagHolder binaryTag = tag == null ? null : BinaryTagHolder.binaryTagHolder((String)tag);
            return HoverEvent.showItem((Key)Key.key((String)id), (int)countInt, (BinaryTagHolder)binaryTag);
        }
        if (action == HoverEvent.Action.SHOW_ENTITY) {
            NBTCompound name = contents.getCompound("name");
            Component nameComponent = name == null ? null : this.deserializeComponent(name);
            String type = contents.getString("type");
            Check.notNull(type, "Show entity hover event must have a type field");
            String id = contents.getString("id");
            Check.notNull(id, "Show entity hover event must have an id field");
            return HoverEvent.showEntity((Key)Key.key((String)type), (UUID)UUID.fromString(id), (Component)nameComponent);
        }
        throw new UnsupportedOperationException("Unknown hover event action: " + actionName);
    }

    @NotNull
    private NBT serializeComponent(@NotNull Component component) {
        HoverEvent hoverEvent;
        ClickEvent clickEvent;
        String insertion;
        TextDecoration.State obfuscated;
        TextDecoration.State strikethrough;
        TextDecoration.State underlined;
        TextDecoration.State italic;
        TextDecoration.State bold;
        Key font;
        Style style;
        TextColor color;
        MutableNBTCompound compound = new MutableNBTCompound();
        if (component instanceof TextComponent) {
            TextComponent text = (TextComponent)component;
            compound.setString("type", "text");
            compound.setString("text", text.content());
        } else if (component instanceof TranslatableComponent) {
            List args;
            TranslatableComponent translatable = (TranslatableComponent)component;
            compound.setString("type", "translatable");
            compound.setString("translate", translatable.key());
            String fallback = translatable.fallback();
            if (fallback != null) {
                compound.setString("fallback", fallback);
            }
            if (!(args = translatable.arguments()).isEmpty()) {
                compound.set("with", this.serializeTranslationArgs(args));
            }
        } else if (component instanceof ScoreComponent) {
            ScoreComponent score = (ScoreComponent)component;
            compound.setString("type", "score");
            MutableNBTCompound scoreCompound = new MutableNBTCompound();
            scoreCompound.setString("name", score.name());
            scoreCompound.setString("objective", score.objective());
            String value = score.value();
            if (value != null) {
                scoreCompound.setString("value", value);
            }
            compound.set("score", (NBT)scoreCompound.toCompound());
        } else if (component instanceof SelectorComponent) {
            SelectorComponent selector = (SelectorComponent)component;
            compound.setString("type", "selector");
            compound.setString("selector", selector.pattern());
            Component separator = selector.separator();
            if (separator != null) {
                compound.set("separator", this.serializeComponent(separator));
            }
        } else if (component instanceof KeybindComponent) {
            KeybindComponent keybind = (KeybindComponent)component;
            compound.setString("type", "keybind");
            compound.setString("keybind", keybind.keybind());
        } else {
            if (component instanceof NBTComponent) {
                NBTComponent nbt = (NBTComponent)component;
                throw new UnsupportedOperationException("NBTComponent is not implemented yet");
            }
            throw new UnsupportedOperationException("Unknown component type: " + component.getClass().getName());
        }
        if (!component.children().isEmpty()) {
            ArrayList<NBT> children = new ArrayList<NBT>();
            for (Component child : component.children()) {
                children.add(this.serializeComponent(child));
            }
            compound.set("extra", (NBT)new NBTList(NBTType.TAG_Compound, children));
        }
        if ((color = (style = component.style()).color()) != null) {
            if (color instanceof NamedTextColor) {
                NamedTextColor named = (NamedTextColor)color;
                compound.setString("color", named.toString());
            } else {
                compound.setString("color", color.asHexString());
            }
        }
        if ((font = style.font()) != null) {
            compound.setString("font", font.toString());
        }
        if ((bold = style.decoration(TextDecoration.BOLD)) != TextDecoration.State.NOT_SET) {
            this.setBool(compound, "bold", bold == TextDecoration.State.TRUE);
        }
        if ((italic = style.decoration(TextDecoration.ITALIC)) != TextDecoration.State.NOT_SET) {
            this.setBool(compound, "italic", italic == TextDecoration.State.TRUE);
        }
        if ((underlined = style.decoration(TextDecoration.UNDERLINED)) != TextDecoration.State.NOT_SET) {
            this.setBool(compound, "underlined", underlined == TextDecoration.State.TRUE);
        }
        if ((strikethrough = style.decoration(TextDecoration.STRIKETHROUGH)) != TextDecoration.State.NOT_SET) {
            this.setBool(compound, "strikethrough", strikethrough == TextDecoration.State.TRUE);
        }
        if ((obfuscated = style.decoration(TextDecoration.OBFUSCATED)) != TextDecoration.State.NOT_SET) {
            this.setBool(compound, "obfuscated", obfuscated == TextDecoration.State.TRUE);
        }
        if ((insertion = component.insertion()) != null) {
            compound.setString("insertion", insertion);
        }
        if ((clickEvent = component.clickEvent()) != null) {
            compound.set("clickEvent", this.serializeClickEvent(clickEvent));
        }
        if ((hoverEvent = component.hoverEvent()) != null) {
            compound.set("hoverEvent", this.serializeHoverEvent(hoverEvent));
        }
        return compound.toCompound();
    }

    @NotNull
    private NBT serializeTranslationArgs(@NotNull Collection<TranslationArgument> args) {
        ArrayList<NBT> list = new ArrayList<NBT>();
        for (TranslationArgument arg : args) {
            list.add(this.serializeComponent(arg.asComponent()));
        }
        return new NBTList(NBTType.TAG_Compound, list);
    }

    @NotNull
    private NBT serializeClickEvent(@NotNull ClickEvent event) {
        MutableNBTCompound compound = new MutableNBTCompound();
        compound.setString("action", event.action().toString());
        compound.setString("value", event.value());
        return compound.toCompound();
    }

    @NotNull
    private NBT serializeHoverEvent(@NotNull HoverEvent<?> event) {
        MutableNBTCompound compound = new MutableNBTCompound();
        compound.setString("action", event.action().toString());
        if (event.action() == HoverEvent.Action.SHOW_TEXT) {
            Component value = (Component)event.value();
            compound.set("contents", this.serializeComponent(value));
        } else if (event.action() == HoverEvent.Action.SHOW_ITEM) {
            BinaryTagHolder tag;
            HoverEvent.ShowItem value = (HoverEvent.ShowItem)event.value();
            MutableNBTCompound itemCompound = new MutableNBTCompound();
            itemCompound.setString("id", value.item().asString());
            if (value.count() != 1) {
                itemCompound.setInt("count", value.count());
            }
            if ((tag = value.nbt()) != null) {
                itemCompound.setString("tag", tag.string());
            }
            compound.set("contents", (NBT)itemCompound.toCompound());
        } else if (event.action() == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity value = (HoverEvent.ShowEntity)event.value();
            MutableNBTCompound entityCompound = new MutableNBTCompound();
            Component name = value.name();
            if (name != null) {
                entityCompound.set("name", this.serializeComponent(name));
            }
            entityCompound.setString("type", value.type().asString());
            entityCompound.setString("id", value.id().toString());
            compound.set("contents", (NBT)entityCompound.toCompound());
        } else {
            throw new UnsupportedOperationException("Unknown hover event action: " + event.action());
        }
        return compound.toCompound();
    }

    private void setBool(@NotNull MutableNBTCompound compound, @NotNull String key, boolean value) {
        compound.setByte(key, value ? (byte)1 : 0);
    }
}

