/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biome;

import java.util.Locale;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.world.biome.BiomeParticle;
import org.jetbrains.annotations.NotNull;

public record BiomeEffects(int fogColor, int skyColor, int waterColor, int waterFogColor, int foliageColor, int grassColor, GrassColorModifier grassColorModifier, BiomeParticle biomeParticle, NamespaceID ambientSound, MoodSound moodSound, AdditionsSound additionsSound, Music music) {
    public static Builder builder() {
        return new Builder();
    }

    public CompoundBinaryTag toNbt() {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        builder.putInt("fog_color", this.fogColor);
        if (this.foliageColor != -1) {
            builder.putInt("foliage_color", this.foliageColor);
        }
        if (this.grassColor != -1) {
            builder.putInt("grass_color", this.grassColor);
        }
        builder.putInt("sky_color", this.skyColor);
        builder.putInt("water_color", this.waterColor);
        builder.putInt("water_fog_color", this.waterFogColor);
        if (this.grassColorModifier != null) {
            builder.putString("grass_color_modifier", this.grassColorModifier.name().toLowerCase(Locale.ROOT));
        }
        if (this.biomeParticle != null) {
            builder.put("particle", (BinaryTag)this.biomeParticle.toNbt());
        }
        if (this.ambientSound != null) {
            builder.putString("ambient_sound", this.ambientSound.toString());
        }
        if (this.moodSound != null) {
            builder.put("mood_sound", (BinaryTag)this.moodSound.toNbt());
        }
        if (this.additionsSound != null) {
            builder.put("additions_sound", (BinaryTag)this.additionsSound.toNbt());
        }
        if (this.music != null) {
            builder.put("music", (BinaryTag)this.music.toNbt());
        }
        return builder.build();
    }

    public static enum GrassColorModifier {
        NONE,
        DARK_FOREST,
        SWAMP;

    }

    public record MoodSound(NamespaceID sound, int tickDelay, int blockSearchExtent, double offset) {
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("sound", this.sound.toString())).putInt("tick_delay", this.tickDelay)).putInt("block_search_extent", this.blockSearchExtent)).putDouble("offset", this.offset)).build();
        }
    }

    public record AdditionsSound(NamespaceID sound, double tickChance) {
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("sound", this.sound.toString())).putDouble("tick_chance", this.tickChance)).build();
        }
    }

    public record Music(NamespaceID sound, int minDelay, int maxDelay, boolean replaceCurrentMusic) {
        @NotNull
        public CompoundBinaryTag toNbt() {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("sound", this.sound.toString())).putInt("min_delay", this.minDelay)).putInt("max_delay", this.maxDelay)).putBoolean("replace_current_music", this.replaceCurrentMusic)).build();
        }
    }

    public static final class Builder {
        private int fogColor;
        private int skyColor;
        private int waterColor;
        private int waterFogColor;
        private int foliageColor = -1;
        private int grassColor = -1;
        private GrassColorModifier grassColorModifier;
        private BiomeParticle biomeParticle;
        private NamespaceID ambientSound;
        private MoodSound moodSound;
        private AdditionsSound additionsSound;
        private Music music;

        Builder() {
        }

        public Builder fogColor(int fogColor) {
            this.fogColor = fogColor;
            return this;
        }

        public Builder skyColor(int skyColor) {
            this.skyColor = skyColor;
            return this;
        }

        public Builder waterColor(int waterColor) {
            this.waterColor = waterColor;
            return this;
        }

        public Builder waterFogColor(int waterFogColor) {
            this.waterFogColor = waterFogColor;
            return this;
        }

        public Builder foliageColor(int foliageColor) {
            this.foliageColor = foliageColor;
            return this;
        }

        public Builder grassColor(int grassColor) {
            this.grassColor = grassColor;
            return this;
        }

        public Builder grassColorModifier(GrassColorModifier grassColorModifier) {
            this.grassColorModifier = grassColorModifier;
            return this;
        }

        public Builder biomeParticle(BiomeParticle biomeParticle) {
            this.biomeParticle = biomeParticle;
            return this;
        }

        public Builder ambientSound(NamespaceID ambientSound) {
            this.ambientSound = ambientSound;
            return this;
        }

        public Builder moodSound(MoodSound moodSound) {
            this.moodSound = moodSound;
            return this;
        }

        public Builder additionsSound(AdditionsSound additionsSound) {
            this.additionsSound = additionsSound;
            return this;
        }

        public Builder music(Music music) {
            this.music = music;
            return this;
        }

        public BiomeEffects build() {
            return new BiomeEffects(this.fogColor, this.skyColor, this.waterColor, this.waterFogColor, this.foliageColor, this.grassColor, this.grassColorModifier, this.biomeParticle, this.ambientSound, this.moodSound, this.additionsSound, this.music);
        }
    }
}

