/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerFlag {
    public static final Boolean SHUTDOWN_ON_SIGNAL = ServerFlag.booleanProperty("minestom.shutdown-on-signal", true);
    public static final int SERVER_TICKS_PER_SECOND = ServerFlag.intProperty("minestom.tps", 20);
    public static final int SERVER_MAX_TICK_CATCH_UP = ServerFlag.intProperty("minestom.max-tick-catch-up", 5);
    public static final int CHUNK_VIEW_DISTANCE = ServerFlag.intProperty("minestom.chunk-view-distance", 8);
    public static final int ENTITY_VIEW_DISTANCE = ServerFlag.intProperty("minestom.entity-view-distance", 5);
    public static final int ENTITY_SYNCHRONIZATION_TICKS = ServerFlag.intProperty("minestom.entity-synchronization-ticks", 20);
    public static final int WORKER_COUNT = ServerFlag.intProperty("minestom.workers", Runtime.getRuntime().availableProcessors());
    public static final int MAX_PACKET_SIZE = ServerFlag.intProperty("minestom.max-packet-size", 0x1FFFFF);
    public static final int SOCKET_SEND_BUFFER_SIZE = ServerFlag.intProperty("minestom.send-buffer-size", 262143);
    public static final int SOCKET_RECEIVE_BUFFER_SIZE = ServerFlag.intProperty("minestom.receive-buffer-size", Short.MAX_VALUE);
    public static final int POOLED_BUFFER_SIZE = ServerFlag.intProperty("minestom.pooled-buffer-size", 262143);
    public static final int PLAYER_PACKET_PER_TICK = ServerFlag.intProperty("minestom.packet-per-tick", 20);
    public static final int PLAYER_PACKET_QUEUE_SIZE = ServerFlag.intProperty("minestom.packet-queue-size", 1000);
    public static final int SEND_LIGHT_AFTER_BLOCK_PLACEMENT_DELAY = ServerFlag.intProperty("minestom.send-light-after-block-placement-delay", 100);
    public static final long KEEP_ALIVE_DELAY = ServerFlag.longProperty("minestom.keep-alive-delay", 10000L);
    public static final long KEEP_ALIVE_KICK = ServerFlag.longProperty("minestom.keep-alive-kick", 30000L);
    public static final long LOGIN_PLUGIN_MESSAGE_TIMEOUT = ServerFlag.longProperty("minestom.login-plugin-message-timeout", 5000L);
    public static final float MIN_CHUNKS_PER_TICK = ServerFlag.floatProperty("minestom.chunk-queue.min-per-tick", Float.valueOf(0.01f)).floatValue();
    public static final float MAX_CHUNKS_PER_TICK = ServerFlag.floatProperty("minestom.chunk-queue.max-per-tick", Float.valueOf(64.0f)).floatValue();
    public static final float CHUNKS_PER_TICK_MULTIPLIER = ServerFlag.floatProperty("minestom.chunk-queue.multiplier", Float.valueOf(1.0f)).floatValue();
    public static final boolean GROUPED_PACKET = ServerFlag.booleanProperty("minestom.grouped-packet", true);
    public static final boolean CACHED_PACKET = ServerFlag.booleanProperty("minestom.cached-packet", true);
    public static final boolean VIEWABLE_PACKET = ServerFlag.booleanProperty("minestom.viewable-packet", true);
    public static final boolean TAG_HANDLER_CACHE_ENABLED = ServerFlag.booleanProperty("minestom.tag-handler-cache", true);
    public static final boolean SERIALIZE_EMPTY_COMPOUND = ServerFlag.booleanProperty("minestom.serialization.serialize-empty-nbt-compound", false);
    @NotNull
    public static final String AUTH_URL = ServerFlag.stringProperty("minestom.auth.url", "https://sessionserver.mojang.com/session/minecraft/hasJoined");
    public static final int WORLD_BORDER_SIZE = ServerFlag.intProperty("minestom.world-border-size", 29999984);
    @NotNull
    public static final String MAP_RGB_MAPPING = ServerFlag.stringProperty("minestom.map.rgbmapping", "lazy");
    @Nullable
    public static final String MAP_RGB_REDUCTION = ServerFlag.stringProperty("minestom.map.rgbreduction");
    public static final boolean REGISTRY_LATE_REGISTER = ServerFlag.booleanProperty("minestom.registry.late-register");
    public static final boolean REGISTRY_UNSAFE_OPS = ServerFlag.booleanProperty("minestom.registry.unsafe-ops");
    public static final boolean EVENT_NODE_ALLOW_MULTIPLE_PARENTS = ServerFlag.booleanProperty("minestom.event.multiple-parents");
    public static boolean INSIDE_TEST = ServerFlag.booleanProperty("minestom.inside-test", false);

    private ServerFlag() {
    }

    private static boolean booleanProperty(String name) {
        return Boolean.getBoolean(name);
    }

    private static boolean booleanProperty(String name, boolean defaultValue) {
        boolean result = defaultValue;
        try {
            String value = System.getProperty(name);
            if (value != null) {
                result = Boolean.parseBoolean(value);
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return result;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    private static String stringProperty(@NotNull String name, @Nullable String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    private static String stringProperty(@NotNull String name) {
        return System.getProperty(name);
    }

    private static int intProperty(String name, int defaultValue) {
        return Integer.getInteger(name, defaultValue);
    }

    private static long longProperty(String name, long defaultValue) {
        return Long.getLong(name, defaultValue);
    }

    private static Float floatProperty(String name, Float defaultValue) {
        Float result = defaultValue;
        try {
            String value = System.getProperty(name);
            if (value != null) {
                result = Float.valueOf(Float.parseFloat(value));
            }
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return result;
    }
}

