/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biomes;

import java.util.Locale;
import net.minestom.server.coordinate.Point;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.biomes.BiomeEffects;
import net.minestom.server.world.biomes.BiomeImpl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Biome
extends ProtocolObject {
    @Contract(pure=true)
    @Nullable
    public Registry.BiomeEntry registry();

    @Override
    @NotNull
    public NamespaceID namespace();

    public float depth();

    public float temperature();

    public float scale();

    public float downfall();

    @NotNull
    public BiomeEffects effects();

    @NotNull
    public Precipitation precipitation();

    @NotNull
    public TemperatureModifier temperatureModifier();

    @NotNull
    default public NBTCompound toNbt() {
        Check.notNull(this.name(), "The biome namespace cannot be null");
        Check.notNull(this.effects(), "The biome effects cannot be null");
        return NBT.Compound(element -> {
            element.setFloat("depth", this.depth());
            element.setFloat("temperature", this.temperature());
            element.setFloat("scale", this.scale());
            element.setFloat("downfall", this.downfall());
            element.setByte("has_precipitation", (byte)(this.precipitation() != Precipitation.NONE ? 1 : 0));
            element.setString("precipitation", this.precipitation().name().toLowerCase(Locale.ROOT));
            if (this.temperatureModifier() != TemperatureModifier.NONE) {
                element.setString("temperature_modifier", this.temperatureModifier().name().toLowerCase(Locale.ROOT));
            }
            element.set("effects", (NBT)this.effects().toNbt());
        });
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final BiomeEffects DEFAULT_EFFECTS = BiomeEffects.builder().fogColor(12638463).skyColor(7907327).waterColor(4159204).waterFogColor(329011).build();
        private NamespaceID name;
        private float depth = 0.2f;
        private float temperature = 0.25f;
        private float scale = 0.2f;
        private float downfall = 0.8f;
        private BiomeEffects effects = DEFAULT_EFFECTS;
        private Precipitation precipitation = Precipitation.RAIN;
        private TemperatureModifier temperatureModifier = TemperatureModifier.NONE;

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder name(@NotNull NamespaceID name) {
            this.name = name;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder depth(float depth) {
            this.depth = depth;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder temperature(float temperature) {
            this.temperature = temperature;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder scale(float scale) {
            this.scale = scale;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder downfall(float downfall) {
            this.downfall = downfall;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder effects(@NotNull BiomeEffects effects) {
            this.effects = effects;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder precipitation(@NotNull Precipitation precipitation) {
            this.precipitation = precipitation;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder temperatureModifier(@NotNull TemperatureModifier temperatureModifier) {
            this.temperatureModifier = temperatureModifier;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Biome build() {
            return new BiomeImpl(this.name, this.depth, this.temperature, this.scale, this.downfall, this.effects, this.precipitation, this.temperatureModifier);
        }
    }

    public static enum Precipitation {
        NONE,
        RAIN,
        SNOW;

    }

    public static enum TemperatureModifier {
        NONE,
        FROZEN;

    }

    public static interface Getter {
        @NotNull
        public Biome getBiome(int var1, int var2, int var3);

        @NotNull
        default public Biome getBiome(@NotNull Point point) {
            return this.getBiome(point.blockX(), point.blockY(), point.blockZ());
        }
    }

    public static interface Setter {
        public void setBiome(int var1, int var2, int var3, @NotNull Biome var4);

        default public void setBiome(@NotNull Point blockPosition, @NotNull Biome biome) {
            this.setBiome(blockPosition.blockX(), blockPosition.blockY(), blockPosition.blockZ(), biome);
        }
    }
}

