/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.block;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Objects;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.tag.Tag;
import net.minestom.server.utils.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTCompoundLike;

public class BlockUtils {
    private final Block.Getter instance;
    private final Point position;

    public BlockUtils(Block.Getter instance, Point position) {
        this.instance = instance;
        this.position = position;
    }

    public BlockUtils getRelativeTo(int x, int y, int z) {
        return new BlockUtils(this.instance, this.position.add(x, y, z));
    }

    public BlockUtils above() {
        return this.getRelativeTo(0, 1, 0);
    }

    public BlockUtils below() {
        return this.getRelativeTo(0, -1, 0);
    }

    public BlockUtils north() {
        return this.getRelativeTo(0, 0, -1);
    }

    public BlockUtils east() {
        return this.getRelativeTo(1, 0, 0);
    }

    public BlockUtils south() {
        return this.getRelativeTo(0, 0, 1);
    }

    public BlockUtils west() {
        return this.getRelativeTo(-1, 0, 0);
    }

    public Block getBlock() {
        return this.instance.getBlock(this.position);
    }

    public boolean equals(Block block) {
        return this.getBlock().compare(block);
    }

    public static Map<String, String> parseProperties(String query) {
        if (!query.startsWith("[") || !query.endsWith("]")) {
            return Map.of();
        }
        if (query.length() == 2) {
            return Map.of();
        }
        int entries = StringUtils.countMatches(query, ',') + 1;
        assert (entries > 0);
        Object[] keys = new String[entries];
        Object[] values = new String[entries];
        int entryCount = 0;
        int length = query.length() - 1;
        int start = 1;
        for (int index = 1; index <= length; ++index) {
            if (query.charAt(index) != ',' && index != length) continue;
            int equalIndex = query.indexOf(61, start);
            if (equalIndex != -1) {
                String key = query.substring(start, equalIndex).trim();
                String value = query.substring(equalIndex + 1, index).trim();
                keys[entryCount] = key;
                values[entryCount++] = value;
            }
            start = index + 1;
        }
        return new Object2ObjectArrayMap(keys, values, entryCount);
    }

    @Nullable
    public static NBTCompound extractClientNbt(@NotNull Block block) {
        if (!block.registry().isBlockEntity()) {
            return null;
        }
        BlockHandler handler = block.handler();
        NBTCompound blockNbt = Objects.requireNonNullElseGet(block.nbt(), NBTCompound::new);
        if (handler != null) {
            return NBT.Compound(nbt -> {
                for (Tag<?> tag : handler.getBlockEntityTags()) {
                    Object value = tag.read((NBTCompoundLike)blockNbt);
                    if (value == null) continue;
                    tag.writeUnsafe(nbt, value);
                }
            });
        }
        return blockNbt;
    }
}

