/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.particle.data;

import net.kyori.adventure.util.RGBLike;
import net.minestom.server.color.Color;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.particle.Particle;
import net.minestom.server.particle.data.ParticleData;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record DustColorTransitionParticleData(@NotNull RGBLike from, float scale, @NotNull RGBLike to) implements ParticleData
{
    public DustColorTransitionParticleData(@NotNull RGBLike from, float scale, @NotNull RGBLike to) {
        Check.argCondition((double)scale < 0.01 || scale > 4.0f, "scale must be between 0.01 and 4: was {0}", Float.valueOf(scale));
    }

    DustColorTransitionParticleData() {
        this(new Color(255, 255, 255), 1.0f, new Color(255, 255, 255));
    }

    DustColorTransitionParticleData(NetworkBuffer buffer) {
        this(new Color((int)(buffer.read(NetworkBuffer.FLOAT).floatValue() * 255.0f), (int)(buffer.read(NetworkBuffer.FLOAT).floatValue() * 255.0f), (int)(buffer.read(NetworkBuffer.FLOAT).floatValue() * 255.0f)), buffer.read(NetworkBuffer.FLOAT).floatValue(), new Color((int)(buffer.read(NetworkBuffer.FLOAT).floatValue() * 255.0f), (int)(buffer.read(NetworkBuffer.FLOAT).floatValue() * 255.0f), (int)(buffer.read(NetworkBuffer.FLOAT).floatValue() * 255.0f)));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.FLOAT, Float.valueOf((float)this.from.red() / 255.0f));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf((float)this.from.green() / 255.0f));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf((float)this.from.blue() / 255.0f));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.scale));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf((float)this.to.red() / 255.0f));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf((float)this.to.green() / 255.0f));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf((float)this.to.blue() / 255.0f));
    }

    @Override
    public boolean validate(int particleId) {
        return particleId == Particle.DUST_COLOR_TRANSITION.id();
    }
}

