/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.player;

import java.util.List;
import java.util.UUID;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public record GameProfile(@NotNull UUID uuid, @NotNull String name, @NotNull @NotNull List<@NotNull Property> properties) implements NetworkBuffer.Writer
{
    public static final int MAX_PROPERTIES = 1024;

    public GameProfile(@NotNull UUID uuid, @NotNull String name, @NotNull List<Property> properties) {
        if (name.isBlank()) {
            throw new IllegalArgumentException("Name cannot be blank");
        }
        if (name.length() > 16) {
            throw new IllegalArgumentException("Name length cannot be greater than 16 characters");
        }
        properties = List.copyOf(properties);
    }

    public GameProfile(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.UUID), reader.read(NetworkBuffer.STRING), reader.readCollection(Property::new, 1024));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.UUID, this.uuid);
        writer.write(NetworkBuffer.STRING, this.name);
        writer.writeCollection(this.properties);
    }

    public record Property(@NotNull String name, @NotNull String value, @Nullable String signature) implements NetworkBuffer.Writer
    {
        public Property(@NotNull String name, @NotNull String value) {
            this(name, value, null);
        }

        public Property(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.readOptional(NetworkBuffer.STRING));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.name);
            writer.write(NetworkBuffer.STRING, this.value);
            writer.writeOptional(NetworkBuffer.STRING, this.signature);
        }
    }
}

