/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record SpawnExperienceOrbPacket(int entityId, @NotNull Pos position, short expCount) implements ServerPacket
{
    public SpawnExperienceOrbPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), new Pos(reader.read(NetworkBuffer.DOUBLE), reader.read(NetworkBuffer.DOUBLE), reader.read(NetworkBuffer.DOUBLE)), reader.read(NetworkBuffer.SHORT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.DOUBLE, this.position.x());
        writer.write(NetworkBuffer.DOUBLE, this.position.y());
        writer.write(NetworkBuffer.DOUBLE, this.position.z());
        writer.write(NetworkBuffer.SHORT, this.expCount);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.SPAWN_EXPERIENCE_ORB;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

