/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record SetPassengersPacket(int vehicleEntityId, @NotNull List<Integer> passengersId) implements ServerPacket
{
    public static final int MAX_PASSENGERS = 16384;

    public SetPassengersPacket(int vehicleEntityId, @NotNull List<Integer> passengersId) {
        passengersId = List.copyOf(passengersId);
    }

    public SetPassengersPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.readCollection(NetworkBuffer.VAR_INT, 16384));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.vehicleEntityId);
        writer.writeCollection(NetworkBuffer.VAR_INT, this.passengersId);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.SET_PASSENGERS;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

