/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record SetExperiencePacket(float percentage, int level, int totalExperience) implements ServerPacket
{
    public SetExperiencePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.percentage));
        writer.write(NetworkBuffer.VAR_INT, this.level);
        writer.write(NetworkBuffer.VAR_INT, this.totalExperience);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.SET_EXPERIENCE;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

