/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record PlayerPositionAndLookPacket(Pos position, byte flags, int teleportId) implements ServerPacket
{
    public PlayerPositionAndLookPacket(@NotNull NetworkBuffer reader) {
        this(new Pos(reader.read(NetworkBuffer.DOUBLE), reader.read(NetworkBuffer.DOUBLE), reader.read(NetworkBuffer.DOUBLE), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.FLOAT).floatValue()), reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.VAR_INT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.DOUBLE, this.position.x());
        writer.write(NetworkBuffer.DOUBLE, this.position.y());
        writer.write(NetworkBuffer.DOUBLE, this.position.z());
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.position.yaw()));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.position.pitch()));
        writer.write(NetworkBuffer.BYTE, this.flags);
        writer.write(NetworkBuffer.VAR_INT, this.teleportId);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.PLAYER_POSITION_AND_LOOK;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

