/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import java.util.UUID;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record PlayerInfoRemovePacket(@NotNull @NotNull List<@NotNull UUID> uuids) implements ServerPacket
{
    public static final int MAX_ENTRIES = 1024;

    public PlayerInfoRemovePacket(@NotNull UUID uuid) {
        this(List.of(uuid));
    }

    public PlayerInfoRemovePacket(@NotNull List<UUID> uuids) {
        uuids = List.copyOf(uuids);
    }

    public PlayerInfoRemovePacket(@NotNull NetworkBuffer reader) {
        this(reader.readCollection(NetworkBuffer.UUID, 1024));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeCollection(NetworkBuffer.UUID, this.uuids);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.PLAY -> ServerPacketIdentifier.PLAYER_INFO_REMOVE;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.PLAY);
        };
    }
}

