/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.common;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record PingResponsePacket(long number) implements ServerPacket
{
    public PingResponsePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.LONG));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.LONG, this.number);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.STATUS -> 1;
            case ConnectionState.PLAY -> ServerPacketIdentifier.PING_RESPONSE;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.STATUS);
        };
    }
}

