/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.common;

import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record KeepAlivePacket(long id) implements ServerPacket
{
    public KeepAlivePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.LONG));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.LONG, this.id);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.CONFIGURATION -> 3;
            case ConnectionState.PLAY -> ServerPacketIdentifier.KEEP_ALIVE;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.CONFIGURATION, ConnectionState.PLAY);
        };
    }
}

