/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.common;

import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ComponentHoldingServerPacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public record DisconnectPacket(@NotNull Component message) implements ComponentHoldingServerPacket
{
    public DisconnectPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.COMPONENT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.COMPONENT, this.message);
    }

    @Override
    public int getId(@NotNull ConnectionState state) {
        return switch (state) {
            case ConnectionState.CONFIGURATION -> 1;
            case ConnectionState.PLAY -> ServerPacketIdentifier.DISCONNECT;
            default -> PacketUtils.invalidPacketState(this.getClass(), state, ConnectionState.CONFIGURATION, ConnectionState.PLAY);
        };
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        return List.of(this.message);
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        return new DisconnectPacket((Component)operator.apply(this.message));
    }
}

