/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minestom.server.ServerFlag;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.server.FramedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CachedPacket
implements SendablePacket {
    private final Supplier<ServerPacket> packetSupplier;
    private volatile SoftReference<FramedPacket> packet;

    public CachedPacket(@NotNull @NotNull Supplier<@NotNull ServerPacket> packetSupplier) {
        this.packetSupplier = packetSupplier;
    }

    public CachedPacket(@NotNull ServerPacket packet) {
        this(() -> packet);
    }

    public void invalidate() {
        this.packet = null;
    }

    @NotNull
    public ServerPacket packet(@NotNull ConnectionState state) {
        FramedPacket cache = this.updatedCache(state);
        return cache != null ? cache.packet() : this.packetSupplier.get();
    }

    @Nullable
    public ByteBuffer body(@NotNull ConnectionState state) {
        FramedPacket cache = this.updatedCache(state);
        return cache != null ? cache.body() : null;
    }

    @Nullable
    private FramedPacket updatedCache(@NotNull ConnectionState state) {
        FramedPacket cache;
        if (!ServerFlag.CACHED_PACKET) {
            return null;
        }
        SoftReference<FramedPacket> ref = this.packet;
        if (ref == null || (cache = ref.get()) == null) {
            cache = PacketUtils.allocateTrimmedPacket(state, this.packetSupplier.get());
            this.packet = new SoftReference<FramedPacket>(cache);
        }
        return cache;
    }

    public boolean isValid() {
        return this.packet != null && this.packet.get() != null;
    }
}

