/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.utils.Rotation;
import org.jetbrains.annotations.NotNull;

public record ClientUpdateStructureBlockPacket(Point location, Action action, Mode mode, String name, Point offset, Point size, Mirror mirror, Rotation rotation, String metadata, float integrity, long seed, byte flags) implements ClientPacket
{
    public static final byte IGNORE_ENTITIES = 1;
    public static final byte SHOW_AIR = 2;
    public static final byte SHOW_BOUNDING_BOX = 4;

    public ClientUpdateStructureBlockPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BLOCK_POSITION), reader.readEnum(Action.class), reader.readEnum(Mode.class), reader.read(NetworkBuffer.STRING), new Vec(reader.read(NetworkBuffer.BYTE).byteValue(), reader.read(NetworkBuffer.BYTE).byteValue(), reader.read(NetworkBuffer.BYTE).byteValue()), new Vec(reader.read(NetworkBuffer.BYTE).byteValue(), reader.read(NetworkBuffer.BYTE).byteValue(), reader.read(NetworkBuffer.BYTE).byteValue()), Mirror.values()[reader.read(NetworkBuffer.VAR_INT)], ClientUpdateStructureBlockPacket.fromRestrictedRotation(reader.read(NetworkBuffer.VAR_INT)), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_LONG), reader.read(NetworkBuffer.BYTE));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BLOCK_POSITION, this.location);
        writer.writeEnum(Action.class, this.action);
        writer.writeEnum(Mode.class, this.mode);
        writer.write(NetworkBuffer.STRING, this.name);
        writer.write(NetworkBuffer.BYTE, (byte)this.offset.x());
        writer.write(NetworkBuffer.BYTE, (byte)this.offset.y());
        writer.write(NetworkBuffer.BYTE, (byte)this.offset.z());
        writer.write(NetworkBuffer.BYTE, (byte)this.size.x());
        writer.write(NetworkBuffer.BYTE, (byte)this.size.y());
        writer.write(NetworkBuffer.BYTE, (byte)this.size.z());
        writer.write(NetworkBuffer.VAR_INT, this.mirror.ordinal());
        writer.write(NetworkBuffer.VAR_INT, ClientUpdateStructureBlockPacket.toRestrictedRotation(this.rotation));
        writer.write(NetworkBuffer.STRING, this.metadata);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.integrity));
        writer.write(NetworkBuffer.VAR_LONG, this.seed);
        writer.write(NetworkBuffer.BYTE, this.flags);
    }

    private static int toRestrictedRotation(Rotation rotation) {
        return switch (rotation) {
            case Rotation.NONE -> 0;
            case Rotation.CLOCKWISE -> 1;
            case Rotation.FLIPPED -> 2;
            case Rotation.COUNTER_CLOCKWISE -> 3;
            default -> throw new IllegalArgumentException("ClientUpdateStructurePacket#rotation must be a valid 90-degree rotation.");
        };
    }

    private static Rotation fromRestrictedRotation(int rotation) {
        return switch (rotation) {
            case 0 -> Rotation.NONE;
            case 1 -> Rotation.CLOCKWISE;
            case 2 -> Rotation.FLIPPED;
            case 3 -> Rotation.COUNTER_CLOCKWISE;
            default -> throw new IllegalArgumentException("ClientUpdateStructurePacket#rotation must be a valid 90-degree rotation.");
        };
    }

    public static enum Action {
        UPDATE_DATA,
        SAVE,
        LOAD,
        DETECT_SIZE;

    }

    public static enum Mode {
        SAVE,
        LOAD,
        CORNER,
        DATA;

    }

    public static enum Mirror {
        NONE,
        LEFT_RIGHT,
        FRONT_BACK;

    }
}

