/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import java.util.List;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public record ClientClickWindowPacket(byte windowId, int stateId, short slot, byte button, @NotNull ClickType clickType, @NotNull List<ChangedSlot> changedSlots, @NotNull ItemStack clickedItem) implements ClientPacket
{
    public static final int MAX_CHANGED_SLOTS = 128;

    public ClientClickWindowPacket(byte windowId, int stateId, short slot, byte button, @NotNull ClickType clickType, @NotNull List<ChangedSlot> changedSlots, @NotNull ItemStack clickedItem) {
        changedSlots = List.copyOf(changedSlots);
    }

    public ClientClickWindowPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.BYTE), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.SHORT), reader.read(NetworkBuffer.BYTE), reader.readEnum(ClickType.class), reader.readCollection(ChangedSlot::new, 128), reader.read(NetworkBuffer.ITEM));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.BYTE, this.windowId);
        writer.write(NetworkBuffer.VAR_INT, this.stateId);
        writer.write(NetworkBuffer.SHORT, this.slot);
        writer.write(NetworkBuffer.BYTE, this.button);
        writer.write(NetworkBuffer.VAR_INT, this.clickType.ordinal());
        writer.writeCollection(this.changedSlots);
        writer.write(NetworkBuffer.ITEM, this.clickedItem);
    }

    public static enum ClickType {
        PICKUP,
        QUICK_MOVE,
        SWAP,
        CLONE,
        THROW,
        QUICK_CRAFT,
        PICKUP_ALL;

    }

    public record ChangedSlot(short slot, @NotNull ItemStack item) implements NetworkBuffer.Writer
    {
        public ChangedSlot(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.SHORT), reader.read(NetworkBuffer.ITEM));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.SHORT, this.slot);
            writer.write(NetworkBuffer.ITEM, this.item);
        }
    }
}

